/* 
BattleShips.java  22 May 2003 */


import java.awt.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;
import java.awt.geom.*;		// to get Graphics2D functionality

public class BattleShips{
	 	
	/*----------------------------------------------------------------------- 
	 Constants
	-----------------------------------------------------------------------*/
	
	public static int WATER = 0;
	public static int SHIP  = 1;
	public static int MISS  = 2;
	public static int HIT   = 3;
	public static int WIN   = 4;
	public static int REPEAT = 5;
	
	/*----------------------------------------------------------------------- 
	 Member data
	-----------------------------------------------------------------------*/
	/* the board to be displayed */
	public int board[][];
		
	/* size of the board used in this game */
	int size = 10;
	
	/* location for the display */
	int rowOffset = 100;
	int colOffset = 100;
		
	/*----------------------------------------------------------------------- 
	 Constructors
	------------------------------------------------------------------------- */
	public DisplayBattleShips(int n, int rowOff, int colOff, 
	                          BufferedPanel _window){
		
		if ((n > 0) && (n <= 10))
			this.size = n;
			
		initialize(this.size);
		
		rowOffset = rowOff;
		colOffset = colOff;
		
		window = _window;
	}
        
	public BattleShips(int n){
		
		this(n, 100, 100);
	}
        
	public BattleShips(){

		this(10);
	}
        
    public void showBoard(){
    
    	/* set the color code for board squares */
    	Color[] colors = new Color[]{Color.blue,
    	                             Color.black,
    	                             Color.white,
    	                             Color.red};
    	                             
        if (window == null)
            return;
            
        // get graphics context and set the color
        Graphics2D G = window.getBufferGraphics();
        
        for (int row = 0; row < size; row++)
        	for (int col = 0; col < size; col++){
        	
        		G.setPaint(colors[board[row][col]]);
        
		        // paint the rectangle
		        Rectangle2D.Double R = 
		            new Rectangle2D.Double(colOffset + 20 * col,
		            				       rowOffset + 20 * row, 
		                                   19, 
		                                   19); 

		        G.fill(R); 
		    }
		           
        window.repaint();
    }
        
	/*----------------------------------------------------------------------- 
	 Print all member data
	-----------------------------------------------------------------------*/
	public String toString(){
		return ("new " + getClass().getName() + "(" +
		        this.rowOffset  + ", " + 
		        this.colOffset  + ", " + 
		        this.size       +  ")");
	}
}

