/* 
BattleShips.java  22 May 2003 */


import java.awt.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;
import java.awt.geom.*;		// to get Graphics2D functionality

public class BattleShips{
	 	
	/*----------------------------------------------------------------------- 
	 Constants
	-----------------------------------------------------------------------*/
	
	public static int WATER = 0;
	public static int SHIP  = 1;
	public static int MISS  = 2;
	public static int HIT   = 3;
	public static int WIN   = 4;
	public static int REPEAT = 5;
	
	/*----------------------------------------------------------------------- 
	 Member data
	-----------------------------------------------------------------------*/
	public int board[][] = new int[][]{ {0,0,0,0,0,0,0,0,0,0},
	                                    {0,0,0,0,0,0,0,0,0,0},
	                                    {0,0,0,0,0,0,0,0,0,0},
	                                    {0,0,0,0,0,0,0,0,0,0},
	                                    {0,0,0,0,0,0,0,0,0,0},
	                                    {0,0,0,0,0,0,0,0,0,0},
	                                    {0,0,0,0,0,0,0,0,0,0},
	                                    {0,0,0,0,0,0,0,0,0,0},
	                                    {0,0,0,0,0,0,0,0,0,0},
	                                    {0,0,0,0,0,0,0,0,0,0} };
	/* total number of turns takes */
	int noTurns = 0;
	
	/* total number of places taken by ships */
	int noShips = 0;
	
	/* total number of hits so far */
	int noHits = 0;
	
	/* size of the board used in this game */
	int size = 10;
	
	/*----------------------------------------------------------------------- 
	 Constructors
	------------------------------------------------------------------------- */
	public BattleShips(int n){
		
		if ((n > 0) && (n <= 10))
			size = n;
		initialize(size);
	}
        
	public BattleShips(){

		this(10);
	}
        
	/*----------------------------------------------------------------------- 
	 Initializer
	------------------------------------------------------------------------- */
	/* initialize the board in the given size */
	/* currently assumes size is 10 - fixes ship's locations */
	public void initialize(int n){
		
		board[0][3] = SHIP;
		board[0][4] = SHIP;
		board[2][5] = SHIP;
		board[2][6] = SHIP;
		board[4][8] = SHIP;
		board[5][1] = SHIP;
		board[5][2] = SHIP;
		board[5][3] = SHIP;
		board[5][4] = SHIP;
		board[5][8] = SHIP;
		board[6][8] = SHIP;
		board[7][5] = SHIP;
		board[8][5] = SHIP;
		board[9][5] = SHIP;
		
		noShips = 14;
	}
        
        
	/*----------------------------------------------------------------------- 
	 Reply to user's guess
	-----------------------------------------------------------------------*/
    int replyToGuess(int row, int col){
    
    	noTurns++;
    	
		if (board[row][col] == SHIP){
			
			board[row][col] = HIT;		/* record the hit */			
			noHits++;					/* count the hit */

			if (noShips == noHits)		/* check if win */
				return WIN;
			else
				return HIT;			
		}
		
		if (board[row][col] == WATER){
		
			board[row][col] = MISS;		/* record the miss */			
			return MISS;		
		}
		
		if (  (board[row][col] == HIT)
		   || (board[row][col] == MISS) ){
		   
		   return REPEAT;		
		}
		
	   return REPEAT;		
		
    }
    
    public void showBoard(BufferedPanel window){
    
    	/* set the color code for board squares */
    	Color[] colors = new Color[]{Color.blue,
    	                             Color.black,
    	                             Color.white,
    	                             Color.red};
    	                             
        if (window == null)
            return;
            
        // get graphics context and set the color
        Graphics2D G = window.getBufferGraphics();
        
        for (int row = 0; row < size; row++)
        	for (int col = 0; col < size; col++){
        	
        		G.setPaint(colors[board[row][col]]);
        
		        // paint the rectangle
		        Rectangle2D.Double R = 
		            new Rectangle2D.Double(100 + 20 * row, 
		                                   100 + 20 * col, 
		                                   19, 
		                                   19); 

		        G.fill(R); 
		    }
		           
        window.repaint();
    }
        
	/*----------------------------------------------------------------------- 
	 Print all member data
	-----------------------------------------------------------------------*/
	public String toString(){
		return ("new " + getClass().getName() + "(" +
		        this.noTurns  + ", " + 
		        this.noShips  + ", " + 
		        this.noHits   +  ")");
	}
}

