/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XByte
extends XNumber {
    private byte value = 0;

    public XByte() {
    }

    public XByte(byte by) {
        this.value = by;
    }

    public XByte(String string) throws ParseException {
        this.fromStringData(string);
    }

    public void fromStringData(String string) throws ParseException {
        byte by = this.value;
        Parser parser = ParserUtilities.getDefaultParser();
        Object object = parser.parse(string);
        if (!(object instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", string.length());
        }
        XNumber xNumber = (XNumber)object;
        this.value = xNumber.byteValue();
        this.changeAdapter.firePropertyChange("value", new Byte(by), string);
    }

    public String toStringData() {
        return this.value + "";
    }

    public boolean equals(Object object) {
        if (object instanceof XByte) {
            return this.getValue() == ((XByte)object).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Byte(this.getValue()).hashCode();
    }

    public String toString() {
        return this.value + "";
    }

    public void setValue(byte by) {
        byte by2 = this.value;
        this.value = by;
        if (this.getValue() != by2) {
            this.changeAdapter.firePropertyChange("value", new Byte(by2), new Byte(this.getValue()));
        }
    }

    public byte getValue() {
        return this.value;
    }

    public byte byteValue() {
        return this.getValue();
    }

    public short shortValue() {
        return this.getValue();
    }

    public int intValue() {
        return this.getValue();
    }

    public long longValue() {
        return this.getValue();
    }

    public float floatValue() {
        return this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public static byte parseByte(String string) throws NumberFormatException {
        try {
            return new XByte((String)string).value;
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(XObject.formatErrorMessage(parseException, string));
        }
    }

    public static byte[] toPrimitiveArray(XByte[] xByteArray) {
        if (xByteArray == null) {
            return null;
        }
        byte[] byArray = new byte[xByteArray.length];
        int n = 0;
        while (n < byArray.length) {
            if (xByteArray[n] != null) {
                byArray[n] = xByteArray[n].getValue();
            }
            ++n;
        }
        return byArray;
    }

    public static XByte[] toXArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        XByte[] xByteArray = new XByte[byArray.length];
        int n = 0;
        while (n < xByteArray.length) {
            xByteArray[n] = new XByte(byArray[n]);
            ++n;
        }
        return xByteArray;
    }
}

