/*
 * Decompiled with CFR 0.152.
 */
import edu.neu.ccs.console.ConsoleAware;
import java.util.StringTokenizer;

public class TestSuite
extends JPFalt {
    public static void main(String[] stringArray) {
        new TestSuite();
    }

    public void TestSocketServer() {
        AsciiSocket asciiSocket = new AsciiSocket();
        this.println("Waiting for an incoming connection on port " + AsciiSocket.DEFAULT_PORT + "...");
        if (asciiSocket.listenOn()) {
            this.println("Connected!!!");
            asciiSocket.writeLine("Hi im an example echo server socket... I'll repeat every line you say");
            IRange iRange = asciiSocket.lineIRange();
            while (iRange.hasMore()) {
                String string = (String)iRange.current();
                this.println(string);
                asciiSocket.writeLine("You typed: " + string);
                if (string.equals("Disconnect")) {
                    asciiSocket.close();
                }
                iRange.next();
            }
            this.println("Disconnected");
        } else {
            this.println("Could not bind ServerSocket");
        }
    }

    public void TestSocketClient() {
        AsciiSocket asciiSocket = new AsciiSocket();
        this.println("Trying to connecto to localhost:" + AsciiSocket.DEFAULT_PORT + "...");
        String string = ConsoleAware.console.in.demandString("Connect to:");
        if (asciiSocket.connectTo(string)) {
            this.println("Connected!!!");
            asciiSocket.writeLine("Hi im an example echo client socket... I'll repeat every line you say");
            IRange iRange = asciiSocket.lineIRange();
            while (iRange.hasMore()) {
                String string2 = (String)iRange.current();
                this.println("Recived line from socket: " + string2);
                asciiSocket.writeLine(ConsoleAware.console.in.demandString("Your turn to type:"));
                if (string2.equals("Disconnect")) {
                    asciiSocket.close();
                }
                iRange.next();
            }
            this.println("Disconnected");
        } else {
            this.println("Could not bind ServerSocket");
        }
    }

    public void TestSimpleSocketEcho() {
        AsciiSocket asciiSocket = new AsciiSocket();
        String string = ConsoleAware.console.in.demandString("Your id:");
        if (asciiSocket.listenOn()) {
            asciiSocket.writeLine(String.valueOf(string) + " ready");
            IRange iRange = asciiSocket.lineIRange();
            while (iRange.hasMore()) {
                String string2 = (String)iRange.current();
                this.println(string2);
                asciiSocket.writeLine("You typed: " + iRange.current());
                iRange.next();
            }
            this.println("Disconnected");
        } else {
            this.println("Could not bind ServerSocket");
        }
    }

    void TestSocketRange() {
        String string = ConsoleAware.console.in.demandString("Name to connect to:");
        int n = 5;
        SocketRange socketRange = new SocketRange(string);
        while (socketRange.hasMore()) {
            String string2 = (String)socketRange.current();
            this.println("You typed: " + string2);
            if (--n == 0) {
                socketRange.disconnect();
            }
            socketRange.next();
        }
        this.println("Done with socket range.");
    }

    void TestInConsoleRangeEcho() {
        InConsoleRange inConsoleRange = new InConsoleRange();
        while (inConsoleRange.hasMore()) {
            String string = (String)inConsoleRange.current();
            this.println("You typed: " + string);
            inConsoleRange.next();
        }
    }

    void TestInConsoleRangeReply() {
        InConsoleRange inConsoleRange = new InConsoleRange();
        while (inConsoleRange.hasMore()) {
            String string = (String)inConsoleRange.current();
            this.println("Received from input stream: " + string);
            String string2 = ConsoleAware.console.in.demandString("Please, reply: ");
            this.println("Posted to output stream: " + string2);
            inConsoleRange.next();
        }
    }

    void TestInConsoleRangeIntegers() {
        InConsoleRange inConsoleRange = new InConsoleRange();
        while (inConsoleRange.hasMore()) {
            String string = (String)inConsoleRange.current();
            int n = new Integer(string);
            this.println("You typed: " + 2 * n);
            inConsoleRange.next();
        }
    }

    void TestNumberGame() {
        NumberGame numberGame = new NumberGame(0, 100);
        InConsoleRange inConsoleRange = new InConsoleRange();
        while (inConsoleRange.hasMore()) {
            String string = (String)inConsoleRange.current();
            int n = new Integer(string);
            this.println(numberGame.replyToGuess(n));
            inConsoleRange.next();
        }
    }

    void TestSocketNumberGame() {
        AsciiSocket asciiSocket = new AsciiSocket();
        NumberGame numberGame = new NumberGame(0, 100);
        int n = numberGame.low;
        this.println("Waiting for an incoming number game connection on port " + AsciiSocket.DEFAULT_PORT + "...");
        if (asciiSocket.listenOn()) {
            this.println("Connection has been made!");
            asciiSocket.writeLine("Welcome to the Number Game");
            InConsoleRange inConsoleRange = new InConsoleRange();
            while (inConsoleRange.hasMore()) {
                String string = (String)inConsoleRange.current();
                this.println("Server received: " + string);
                if (this.isNumber(string)) {
                    n = new Integer(string);
                }
                asciiSocket.writeLine(numberGame.replyToGuess(n));
                this.println(numberGame.replyToGuess(n));
                if (numberGame.replyToGuess(n).equals("BINGO!!!")) {
                    asciiSocket.close();
                }
                inConsoleRange.next();
            }
            this.println("Disconnected");
        } else {
            this.println("Could not bind ServerSocket");
        }
    }

    protected boolean isNumber(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "0123456789");
        return stringTokenizer.hasMoreTokens() ^ true;
    }

    public void TestIsNumber() {
        this.expected(true);
        this.actual(this.isNumber("1224"));
        this.expected(false);
        this.actual(this.isNumber("s123"));
        this.expected(false);
        this.actual(this.isNumber("123."));
        this.expected(false);
        this.actual(this.isNumber("12 3"));
    }

    public void TestClientNumberGame() {
        AsciiSocket asciiSocket = new AsciiSocket();
        this.println("Trying to connecto to localhost:" + AsciiSocket.DEFAULT_PORT + "...");
        String string = ConsoleAware.console.in.demandString("Connect to:");
        if (asciiSocket.connectTo(string)) {
            this.println("Connected!!!");
            asciiSocket.writeLine("Ready to play the game.");
            IRange iRange = asciiSocket.lineIRange();
            while (iRange.hasMore()) {
                String string2 = (String)iRange.current();
                this.println("Client received: " + string2);
                asciiSocket.writeLine(ConsoleAware.console.in.demandString(string2));
                if (string2.equals("Disconnect")) {
                    asciiSocket.close();
                }
                iRange.next();
            }
            this.println("Disconnected");
        } else {
            this.println("Could not bind ServerSocket");
        }
    }

    void TestBattleShips() {
        PlayBattleShips playBattleShips = new PlayBattleShips(10, JPFalt.window);
        playBattleShips.play();
    }

    void TestEliza() {
        Eliza eliza = new Eliza();
        InConsoleRange inConsoleRange = new InConsoleRange();
        while (inConsoleRange.hasMore()) {
            String string = (String)inConsoleRange.current();
            this.println(eliza.selectAnswer(string));
            inConsoleRange.next();
        }
    }
}

