/*
 * Decompiled with CFR 0.152.
 */
import edu.neu.ccs.gui.BufferedPanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class BattleShips {
    public static int WATER = 0;
    public static int SHIP = 1;
    public static int MISS = 2;
    public static int HIT = 3;
    public static int WIN = 4;
    public static int REPEAT = 5;
    public int[][] board = new int[][]{new int[10], new int[10], new int[10], new int[10], new int[10], new int[10], new int[10], new int[10], new int[10], new int[10]};
    int noTurns = 0;
    int noShips = 0;
    int noHits = 0;
    int size = 10;

    public BattleShips(int n) {
        if (n > 0 && n <= 10) {
            this.size = n;
        }
        this.initialize(this.size);
    }

    public BattleShips() {
        this(10);
    }

    public void initialize(int n) {
        this.board[0][3] = SHIP;
        this.board[0][4] = SHIP;
        this.board[2][5] = SHIP;
        this.board[2][6] = SHIP;
        this.board[4][8] = SHIP;
        this.board[5][1] = SHIP;
        this.board[5][2] = SHIP;
        this.board[5][3] = SHIP;
        this.board[5][4] = SHIP;
        this.board[5][8] = SHIP;
        this.board[6][8] = SHIP;
        this.board[7][5] = SHIP;
        this.board[8][5] = SHIP;
        this.board[9][5] = SHIP;
        this.noShips = 14;
    }

    int replyToGuess(int row, int col) {
        ++this.noTurns;
        if (this.board[row][col] == SHIP) {
            this.board[row][col] = HIT;
            ++this.noHits;
            if (this.noShips == this.noHits) {
                return WIN;
            }
            return HIT;
        }
        if (this.board[row][col] == WATER) {
            this.board[row][col] = MISS;
            return MISS;
        }
        if (this.board[row][col] == HIT || this.board[row][col] == MISS) {
            return REPEAT;
        }
        return REPEAT;
    }

    public void showBoard(BufferedPanel window) {
        Color[] colors = new Color[]{Color.blue, Color.black, Color.white, Color.red};
        if (window == null) {
            return;
        }
        Graphics2D G = window.getBufferGraphics();
        int row = 0;
        while (row < this.size) {
            int col = 0;
            while (col < this.size) {
                G.setPaint(colors[this.board[row][col]]);
                Rectangle2D.Double R = new Rectangle2D.Double(100 + 20 * row, 100 + 20 * col, 19.0, 19.0);
                G.fill(R);
                ++col;
            }
            ++row;
        }
        window.repaint();
    }

    public String toString() {
        return "new " + this.getClass().getName() + "(" + this.noTurns + ", " + this.noShips + ", " + this.noHits + ")";
    }
}

