/* 
TestSuiteBuild.java  26 February 2003 */


import java.awt.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;
import java.util.*;

public class TestSuiteBuild extends JPFalt implements BattleshipConstants 
{
    public static void main(String[] args) { new TestSuiteBuild(); }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////
	 	
	/*----------------------------------------------------------------------- 
	 Helper method & test to verify that a String contains only digits
	-----------------------------------------------------------------------*/
    protected boolean isNumber(String s){
    	
    	StringTokenizer st = new StringTokenizer(s, "0123456789");
    	return !(st.hasMoreTokens());
    }
    
    public void TestIsNumber(){
    
    	expected(true);
    	actual(isNumber("1224"));
    	
    	expected(false);
    	actual(isNumber("s123"));
    	
    	expected(false);
    	actual(isNumber("123."));
    	
    	expected(false);
    	actual(isNumber("12 3"));
    	
    	
    }
    
	/*----------------------------------------------------------------------- 
	 Test Battleships
	-----------------------------------------------------------------------*/
	/*----------------------------------------------------------------------- 
	 Test Board class
	-----------------------------------------------------------------------*/
	void TestBoard(){
	
		testHeader("Board class");
		
		Board playerBoard = new Board(10, 25, 50, window);
		Board opponentBoard = new Board(5, 225, 50, window);
		
		/* notice: data is in column-first order here */
		playerBoard.b = new int[][]{ {1,0,0,0,0,0,0,0,0,0},
	                                 {0,2,0,0,0,0,0,0,0,0},
	                                 {0,0,3,0,0,0,0,0,0,0},
	                                 {0,0,0,1,0,0,0,0,0,0},
	                                 {0,0,0,0,2,0,0,0,0,0},
	                                 {0,0,0,0,0,3,0,0,0,0},
	                                 {0,0,0,0,0,0,1,0,0,0},
	                                 {0,0,0,0,0,0,0,2,0,0},
	                                 {0,0,0,0,0,0,0,0,3,0},
	                                 {0,0,0,0,0,0,0,0,0,0} };
	                                ;
		opponentBoard.b = new int[][]{ {0,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {0,1,0,0,0} };
		
		playerBoard.display();
		opponentBoard.display();
		
		println("Print opponent board - size 5:\n");
		println(opponentBoard);

	}
	
	/*----------------------------------------------------------------------- 
	 Test BoardInfo class - Part 1: processGuess
	-----------------------------------------------------------------------*/
	void TestBoardInfo1(){
	
		testHeader("BoardInfo class: processGuess");

		Board opponentBoard = new Board(5, 225, 50, window);
		
		/* notice - data is in column-first order here */	                                ;
		opponentBoard.b = new int[][]{ {0,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {0,1,0,0,0} };

		opponentBoard.display();
		
		BoardInfo opponentBinfo = new BoardInfo(opponentBoard);
				

		println("Testing processGuess with opponent board");
		
		/* repeated hit */
		expected(REPEAT);
		actual(opponentBinfo.processGuess(1, 0));

		/* new hit */
		expected(HIT);
		actual(opponentBinfo.processGuess(0, 1));

		/* new miss */
		expected(MISS);
		actual(opponentBinfo.processGuess(1, 2));

		/* repeated miss */
		expected(REPEAT);
		actual(opponentBinfo.processGuess(0, 3));

		opponentBinfo.processGuess(1, 1);
		opponentBinfo.processGuess(2, 1);
		opponentBinfo.processGuess(3, 1);

		/* should have hit all ships by now */
		expected(WIN);
		actual(opponentBinfo.processGuess(4, 1));


		println("Print opponent board - size 5:\n");
		println(opponentBoard);

	}
	
	/*----------------------------------------------------------------------- 
	 Test BoardInfo class - Part 2: initMyReply
	-----------------------------------------------------------------------*/
	void TestBoardInfoInitMyReply(){
	
		testHeader("BoardInfo class: initMyReply");

		Board opponentBoard = new Board(5, 225, 50, window);
		
		
		BoardInfo opponentBinfo = new BoardInfo(opponentBoard);
		opponentBinfo.initMyReply();
		opponentBoard.display();
		pressReturn("Initial board shown");

		println("Testing processGuess with opponent board");
		
		/* repeated hit */
		expected(REPEAT);
		actual(opponentBinfo.processGuess(1, 0));

		/* new hit */
		expected(HIT);
		actual(opponentBinfo.processGuess(0, 1));

		/* new miss */
		expected(MISS);
		actual(opponentBinfo.processGuess(1, 2));

		/* repeated miss */
		expected(REPEAT);
		actual(opponentBinfo.processGuess(0, 3));

		opponentBinfo.processGuess(1, 1);
		opponentBinfo.processGuess(2, 1);
		opponentBinfo.processGuess(3, 1);

		/* should have hit all ships by now */
		expected(WIN);
		actual(opponentBinfo.processGuess(4, 1));


		println("Print opponent board - size 5:\n");
		println(opponentBoard);

	}
	
	/*----------------------------------------------------------------------- 
	 Test BoardInfo class - Part 3: initMyGuess and processResult
	-----------------------------------------------------------------------*/
	void TestBoardInitMyGuess(){
	
		testHeader("BoardInfo class: initMyGuess and processResult");

		Board opponentBoard = new Board(5, 225, 50, window);
		

		opponentBoard.display();
		
		BoardInfo opponentBinfo = new BoardInfo(opponentBoard);
				
		/* notice - data is in column-first order here */	                                ;
		opponentBinfo.initMyGuess();

		println("Testing processResult with opponent board");
		
		/* first hit */
		expected(OK);
		actual(opponentBinfo.processResult(1, 0, HIT));

		/* repeat hit */
		expected(OK);
		actual(opponentBinfo.processResult(1, 0, REPEAT));

		/* new miss */
		expected(OK);
		actual(opponentBinfo.processResult(1, 2, MISS));

		/* repeated miss */
		expected(OK);
		actual(opponentBinfo.processResult(1, 2, REPEAT));

		opponentBinfo.processResult(1, 1, HIT);
		opponentBinfo.processResult(2, 1, HIT);
		opponentBinfo.processResult(3, 1, HIT);

		/* should have hit all ships by now */
		expected(WIN);
		actual(opponentBinfo.processResult(3, 0, HIT));


		println("Print opponent board - size 5:\n");
		println(opponentBoard);

	}
	
	/*----------------------------------------------------------------------- 
	 Test Player class
	-----------------------------------------------------------------------*/
	void TestBoardPlayer(){
	
		Board playerBoard = new Board(10, 25, 50, window);
		
		Player   player   = 
			new Player  (new BoardInfo(playerBoard),   
						 new IOConsoleChannel());
			
		player.player.initialize();
		player.player.board.display();
		
		println("Starting playTurn()");
		println("Protocol:");
		
		println("Player makes a guess: guess(x y) ");
		println("Respond with one digit: MISS = 2, HIT = 3, REPEAT = 5");
		println("Player resonds with either 'Your turn' or 'I win'"); 
		
		while(console.confirm("Another turn", true)){
		
			player.playTurn();
			println("Finished one turn.");
		}
		
		println("\n TEST COMPLETED");

	}
	
	/*----------------------------------------------------------------------- 
	 Test Opponent class
	-----------------------------------------------------------------------*/
	void TestBoardOpponent(){
	
		Board opponentBoard = new Board(10, 225, 50, window);
		
		Opponent opponent   = 
			new Opponent  (new BoardInfo(opponentBoard),   
						 new IOConsoleChannel());
			
		opponent.opponent.initialize();
		opponent.opponent.board.display();
		
		println("Starting playTurn()");
		println("Protocol:");
		
		println("Opponent reads a guess: guess(x y) ");
		println("Opponent responds with one digit:");
		println("MISS = 2, HIT = 3, WIN = 4, REPEAT = 5");
		println("Opponent reads player's message: 'Your turn' or 'I win'"); 
		
		while(console.confirm("Another turn", true)){
		
			opponent.playTurn();
			println("Finished one turn.");
		}
		
		println("\n TEST COMPLETED");

	}
	

	/*----------------------------------------------------------------------- 
	 Test Administrator class: Starter variant
	-----------------------------------------------------------------------*/
    void TestBattleShipsStarter(){
    	Administrator admin = 
    		new Administrator(10, 
							  new IOConsoleChannel(),
							  window,
							  true);
							  
		println("Test Administrator class: Starter variant");		
		println("Game is initialized");
		admin.openGame();
    }

	/*----------------------------------------------------------------------- 
	 Test Administrator class: Responder variant
	-----------------------------------------------------------------------*/
    void TestBattleShipsResponder(){
    	Administrator admin = 
    		new Administrator(10, 
							  new IOConsoleChannel(),
							  window,
							  false);
    											
		println("Test Administrator class: Responder variant");
		println("Game is initialized");
		admin.openGame();
    }

	/*----------------------------------------------------------------------- 
	 Test Administrator class: Server socket variant
	-----------------------------------------------------------------------*/
    void TestServerSocket(){
    
    	int port = console.in.demandInt("Select port number for the server: ");
  
    	Administrator admin = 
    		new Administrator(10, 
							  new ServerChannel(port),
							  window,
							  true);
							  
		println("Test Administrator class: Server starter variant");		
		println("Game is initialized");
		admin.openGame();
    }

	/*----------------------------------------------------------------------- 
	 Test Administrator class: Client socket variant
	-----------------------------------------------------------------------*/
    void TestClientSocket(){

    	int port = console.in.demandInt("Select port number for the client: ");
		String host = console.in.demandString("Select host for the client: ");

    	Administrator admin = 
    		new Administrator(10, 
							  new ClientChannel(host, port),
							  window,
							  false);
							  
		println("Test Administrator class: Client responder variant");		
		println("Game is initialized");
		admin.openGame();
    }

    
}

