/* 
Player.java  22 May 2003 */


import java.awt.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.awt.*;
import java.math.*;
import java.util.*;

public class Player implements BattleshipConstants, ConsoleAware{
	 	
	
	/*----------------------------------------------------------------------- 
	 Member data
	-----------------------------------------------------------------------*/
	/* the class to process game logic for the player */
	public BoardInfo player;
	
	/* the io channel for communication */
	IOChannel io;
			
	/*----------------------------------------------------------------------- 
	 Constructors
	------------------------------------------------------------------------- */
	public Player(BoardInfo _boardInfo, IOChannel _io){
		
		this.io    = _io;
		player = _boardInfo;
	}
                
	/*----------------------------------------------------------------------- 
	 Initialize 
	-----------------------------------------------------------------------*/
    public int initialize(){
    	/* no additional initialization needed now */
    	player.initialize();
    	return player.size;
    }
    
	/*----------------------------------------------------------------------- 
	 Make guesses 
	-----------------------------------------------------------------------*/
    public int playTurn(){
    
        console.out.println("Player's turn");
        
    	/* select your next move */
    	Point p = player.selectGuess();
    	
    	/* write your guess-message to the opponent */
    	console.out.println("my guess(" + p.x + " " + p.y + ")");
    	io.write("guess(" + p.x + " " + p.y + ")");
    	
    	/* read the reply-to-guess message from the opponent */
    	int reply = getNumber(io.read());
    	console.out.println("reply: " + reply);
    	
    	/* process the result */
    	int outcome = player.processResult(p.x, p.y, reply); 
    
    	/* write your-turn-message to the opponent if appropriate */
    	if (outcome == WIN){
    		io.write("I win");
    		return WIN;
    	}
    	
    	else{
    		io.write("Your turn");
    		return OK;	
    	}
    	
    }
    
	/*----------------------------------------------------------------------- 
	 Convert String to a number
	-----------------------------------------------------------------------*/
	public int getNumber(String input){
		
		if (isNumber(input))
			return (new Integer(input)).intValue();
		else {
			console.out.println(
				"Invalid response - not a number; recorded as repeat.");
			return REPEAT;
		}
			
	}

	/*----------------------------------------------------------------------- 
	 Verify that String represents a number
	-----------------------------------------------------------------------*/
	public boolean isNumber(String input){
		
		StringTokenizer st = new StringTokenizer(input, "0123456789");
		return (! (st.hasMoreTokens()));
	}

	/*----------------------------------------------------------------------- 
	 Print all member data
	-----------------------------------------------------------------------*/
	public String toString(){
		return ("new " + getClass().getName() + "(" +
		        this.player  + ")");
	}
}

