/* ------------------------------------------------------------------
   Input Output Console Channel  
*/

import edu.neu.ccs.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.util.*;

import java.io.*;
import java.awt.*;

class IOConsoleChannel implements ConsoleAware, IOChannel{

	public boolean isOpen = false;

    /* open the channel - return true if success */
    public boolean open(){
    	isOpen = true;
    	return true;			/* console is always there */
    } 
    
    /* read one line from the channel - with a prompt */
    public String read(String prompt){
    	return console.in.demandString(prompt);
    }
    
    /* read one line from the channel */
    public String read(){
    	return read("");
    }
    
    /* write one line to the channel */
    public void write(String line){
    	console.out.println(line);
    } 
        
    /* close the channel */
    public void close(){
    	isOpen = false;
    }		

    /* determine whether the channel is open */
    public boolean isOpen(){
    	return isOpen;
    } 

}

