/* 
Administrator.java  22 May 2003 */


import java.awt.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;
import java.awt.geom.*;		// to get Graphics2D functionality

public class Administrator implements BattleshipConstants, ConsoleAware{
	 	
	/*----------------------------------------------------------------------- 
	 Member data
	-----------------------------------------------------------------------*/
	
	/* size of the board used in this game */
	int size = 10;
	
	/* the player and his board */
	public Board playerBoard;
	Player player;
	
	/* the opponent and her board */
	public Board opponentBoard;
	public Opponent opponent;
	
	/* the IO channel */
	public IOChannel io;
	
	/* the graphics window to show the game progress */
	public BufferedPanel window;
	
	/* true if this player starts with guessing */
	public boolean starter = true;
		
	/*----------------------------------------------------------------------- 
	 Constructors
	------------------------------------------------------------------------- */
	public Administrator(int n,
	                     IOChannel channel, 
	                     BufferedPanel _window,
	                     boolean isStarter){
		
		/* determine the size of the board */
		if ((n > 0) && (n <= 10))
			this.size = n;
		
		this.io = channel;
		this.window = _window;
		this.starter = isStarter;
		initialize();
	}
        
	/*----------------------------------------------------------------------- 
	 Initializer
	------------------------------------------------------------------------- */
	/* initialize playes and opponent and their boards */
	public void initialize(){
		
		
		playerBoard = new Board(size, 25, 50, window);
		opponentBoard = new Board(size, 225, 50, window);

		console.out.println("How do you select your guesses?");
		console.out.println("GUI: 0, Random: 1, Console: 2");
				
		int choice = console.in.demandInt("Your choice: ");
		
		player   = new Player  (new BoardInfo(playerBoard, choice), io);
		opponent = new Opponent(new BoardInfo(opponentBoard), io);
		
		opponent.opponent.initialize();
		player.player.initialize();
		
		player.player.board.display();
		opponent.opponent.board.display();
		
		console.out.println("Opponent:\n" + opponent.opponent.board);
		console.out.println("Player:\n" + player.player.board);
	}	
		
	/*----------------------------------------------------------------------- 
	 Open the game
	-----------------------------------------------------------------------*/
	public void openGame(){
	
		/* stop if channel not available */
		if (!(io.open()))
			shutDown("Channel could not open");
			
		else{
			/* if this player is the starter, proceed to guess */
			if (starter){
				io.write("Welcome to the game: I start - reply with 'Your turn'");
				
				/* read initial conversation - up to three lines */
				int n = 3;
				String message = io.read();
				console.out.println("Starter received message:\n" + message);
				while ( (!(message.equals("Your turn"))) && 
				        (n > 0)){
					message = io.read();
					console.out.println("Starter received message:\n" + message);					
					n--;
				};
								
				/* got the "Your turn" response: send my guess */
				if (n > 0)
					myGuess();
				
				/* unless opponent failed to acknowledge */
				else
					shutDown("Failed to start the game");
			}
			
			/* if not starter, invite other player's turn */
			else {
				console.out.println("Received start message from server:\n" + 
				                    io.read());
				io.write("Submit your first guess: ");
				io.write("Your turn");
				console.out.println("Received start message from server:\n" + 
				                    io.read());
			
				yourGuess();
			}
		}
	}
	/*----------------------------------------------------------------------- 
	 This player's turn to guess opponent's positions
	-----------------------------------------------------------------------*/
	public void myGuess(){
		
		/* play your turn and receive the result */
		int result = player.playTurn();
		
		/* if winner, say so and shut down the game */
		if (result == WIN)
			shutDown("Player wins!!! Game ends.");
		
		
		/* if channel is open, await opponent's guess */
		else {
			
			if (io.isOpen())
				yourGuess();
				
			/* channel is closed - shut down */
			else
				shutDown("Channel is closed. Game ends.");			
		}
	}
	
	/*----------------------------------------------------------------------- 
	 Opponent's turn to guess my positions
	-----------------------------------------------------------------------*/
	public void yourGuess(){
	
		/* await opponent's guess */
		int result = opponent.playTurn();
		
		/* if winner, say so and shut down the game */
		if (result == WIN)
			shutDown("Opponent wins!!! Game ends");
			
		/* if channel is open, start your turn */
		else{
		
			if (io.isOpen())
				myGuess();
				
			/* channel is closed - shut down */
			else
				shutDown("Channel is closed. Game ends.");
		}					
	}

	/*----------------------------------------------------------------------- 
	 Shut down the game
	-----------------------------------------------------------------------*/

	public void shutDown(String message){
		
		/* indicate how the game ended */
		if (io.isOpen()){
			console.out.println("Game ends: " + message);
			io.write(message);
			io.close();
		}
		
		else{
			console.out.println("Channel is closed.");
			console.out.println(message);
		}
		
	}
        
	/*----------------------------------------------------------------------- 
	 Print all member data
	-----------------------------------------------------------------------*/
	public String toString(){
		return ("new " + getClass().getName() + "(" +
		        this.player  + ", " + 
		        this.opponent   +  ")");
	}
}

