/*
 * Decompiled with CFR 0.152.
 */
import edu.neu.ccs.gui.BufferedPanel;

public class Administrator
implements BattleshipConstants {
    int size = 10;
    public Board playerBoard;
    Player player;
    public Board opponentBoard;
    public Opponent opponent;
    public IOChannel io;
    public BufferedPanel window;
    public boolean starter = true;

    public Administrator(int n, IOChannel channel, BufferedPanel _window, boolean isStarter) {
        if (n > 0 && n <= 10) {
            this.size = n;
        }
        this.io = channel;
        this.window = this.window;
        this.starter = isStarter;
        this.initialize();
    }

    public void initialize() {
        this.playerBoard = new Board(this.size, 25, 50, this.window);
        this.opponentBoard = new Board(this.size, 225, 50, this.window);
        this.player = new Player(new BoardInfo(this.playerBoard), this.io);
        this.opponent = new Opponent(new BoardInfo(this.opponentBoard), this.io);
        this.opponent.opponent.initialize();
        this.player.player.board.display();
        this.opponent.opponent.board.display();
    }

    public void openGame() {
        if (!this.io.open()) {
            this.shutDown("Channel could not open");
        } else if (this.starter) {
            this.io.write("Welcome to the game: I start");
            if (this.io.read().equals("Your turn")) {
                this.myGuess();
            } else {
                this.shutDown("Failed to start the game");
            }
        } else {
            this.io.write("Your turn");
            this.yourGuess();
        }
    }

    public void myGuess() {
        int result = this.player.playTurn();
        if (result == 4) {
            this.shutDown("I WIN!!! Game ends.");
        } else if (this.io.isOpen()) {
            this.yourGuess();
        } else {
            this.shutDown("Channel is closed. Game ends.");
        }
    }

    public void yourGuess() {
        int result = this.opponent.playTurn();
        if (result == 4) {
            this.shutDown("YOU WIN!!! Game ends");
        } else if (this.io.isOpen()) {
            this.myGuess();
        } else {
            this.shutDown("Channel is closed. Game ends.");
        }
    }

    public void shutDown(String message) {
        System.out.println(message);
    }

    public String toString() {
        return "new " + this.getClass().getName() + "(" + this.player + ", " + this.opponent + ")";
    }
}

