/* 
TestSuiteBuild.java  26 February 2003 */


import java.awt.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;
import java.util.*;

public class TestSuiteBuild extends JPFalt implements BattleshipConstants 
{
    public static void main(String[] args) { new TestSuiteBuild(); }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////
	 	
	/*----------------------------------------------------------------------- 
	 Test server socket and iterator for input of series of lines
	------------------------------------------------------------------------- */
	public void TestSocketServer(){
	
		String inputLine;
		
		AsciiSocket as=new AsciiSocket();
		
		println("Waiting for an incoming connection on port " 
		        +AsciiSocket.DEFAULT_PORT+"...");
		        
		/* establish a connection */
		if(as.listenOn()){
			println("Connected!!!");
			as.writeLine("Hi im an example echo server socket... " + 
			             "I'll repeat every line you say");
			
			for(IRange it=as.lineIRange(); 
			    it.hasMore(); 
			    it.next()){
			    
				inputLine = (String)it.current();
				println(inputLine);
				as.writeLine("You typed: " + inputLine);
				
				if (inputLine.equals("Disconnect"))
					as.close();
			}
			
			println("Disconnected");
		}
		
		else{
			println("Could not bind ServerSocket");
		}
	}
	
	/*----------------------------------------------------------------------- 
	 Test client socket and iterator for input of series of lines
	------------------------------------------------------------------------- */
	public void TestSocketClient(){
	
		String inputLine;
		
		AsciiSocket as=new AsciiSocket();
		
		println("Trying to connecto to localhost:"+AsciiSocket.DEFAULT_PORT+"...");
		String host = console.in.demandString("Connect to:");

		/* establish a connection */
		if(as.connectTo(host)){
			println("Connected!!!");
			as.writeLine("Hi im an example echo client socket... " + 
			             "I'll repeat every line you say");

			for(IRange it=as.lineIRange(); 
			    it.hasMore(); 
			    it.next()){	
			    inputLine = (String)it.current();
				println("Recived line from socket: "+ inputLine);
				as.writeLine(console.in.demandString("Your turn to type:"));

				if (inputLine.equals("Disconnect"))
					as.close();
			}
			
			println("Disconnected");
		}
		
		else{
			println("Could not bind ServerSocket");
		}
	}
	
	/* simplified server socket connection */
	public void TestSimpleSocketEcho(){
	
		String inputLine;
		
		AsciiSocket as=new AsciiSocket();
		String hostid = console.in.demandString("Your id:");
		
		if(as.listenOn()){
			as.writeLine(hostid + " ready");
			
			for(IRange it=as.lineIRange(); 
			    it.hasMore(); 
			    it.next()){
			    
				inputLine = (String)it.current();
				println(inputLine);
				as.writeLine("You typed: "+it.current());
			}
			
			println("Disconnected");
		}
		
		else{
			println("Could not bind ServerSocket");
		}
	}
	

	/*----------------------------------------------------------------------- 
	 Test socket iterator for input of series of lines
	------------------------------------------------------------------------- */
    void TestSocketRange(){
    
		String inputLine;
		String host = console.in.demandString("Name to connect to:");
		
		int n = 5;
		        
        for (IRange it = new SocketRange(host);
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            
            println("You typed: " + inputLine);
            n = n-1;
            if (n == 0)
            	((SocketRange)it).disconnect();
        }
        println("Done with socket range.");        
    }
        
	/*----------------------------------------------------------------------- 
	 Test console iterator for input of series of lines
	------------------------------------------------------------------------- */
    void TestInConsoleRangeEcho(){
    
		String inputLine;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            
            println("You typed: " + inputLine);
        }        
    }
        
	/*----------------------------------------------------------------------- 
	 Test console iterator for input of series of lines, with user responses
	-----------------------------------------------------------------------*/
    void TestInConsoleRangeReply(){
    
		String inputLine;
		String response;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            println("Received from input stream: " + inputLine);
            
            response = console.in.demandString("Please, reply: ");
            println("Posted to output stream: " + response);
        }        
    }
        
	/*----------------------------------------------------------------------- 
	 Test console iterator for input of series of numbers
	-----------------------------------------------------------------------*/
    void TestInConsoleRangeIntegers(){
    
		String inputLine;
		int number;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            number = (new Integer(inputLine)).intValue();
            
            println("You typed: " + 2 * number);
            
        }        
    }

	/*----------------------------------------------------------------------- 
	 Helper method & test to verify that a String contains only digits
	-----------------------------------------------------------------------*/
    protected boolean isNumber(String s){
    	
    	StringTokenizer st = new StringTokenizer(s, "0123456789");
    	return !(st.hasMoreTokens());
    }
    
    public void TestIsNumber(){
    
    	expected(true);
    	actual(isNumber("1224"));
    	
    	expected(false);
    	actual(isNumber("s123"));
    	
    	expected(false);
    	actual(isNumber("123."));
    	
    	expected(false);
    	actual(isNumber("12 3"));
    	
    	
    }
    
	/*----------------------------------------------------------------------- 
	 Test Battleships
	-----------------------------------------------------------------------*/
	/*----------------------------------------------------------------------- 
	 Test Board class
	-----------------------------------------------------------------------*/
	void TestBoard(){
	
		testHeader("Board class");
		
		Board playerBoard = new Board(10, 25, 50, window);
		Board opponentBoard = new Board(5, 225, 50, window);
		
		/* notice: data is in column-first order here */
		playerBoard.b = new int[][]{ {1,0,0,0,0,0,0,0,0,0},
	                                 {0,2,0,0,0,0,0,0,0,0},
	                                 {0,0,3,0,0,0,0,0,0,0},
	                                 {0,0,0,1,0,0,0,0,0,0},
	                                 {0,0,0,0,2,0,0,0,0,0},
	                                 {0,0,0,0,0,3,0,0,0,0},
	                                 {0,0,0,0,0,0,1,0,0,0},
	                                 {0,0,0,0,0,0,0,2,0,0},
	                                 {0,0,0,0,0,0,0,0,3,0},
	                                 {0,0,0,0,0,0,0,0,0,0} };
	                                ;
		opponentBoard.b = new int[][]{ {0,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {0,1,0,0,0} };
		
		playerBoard.display();
		opponentBoard.display();
		
		println("Print opponent board - size 5:\n");
		println(opponentBoard);

	}
	
	/*----------------------------------------------------------------------- 
	 Test BoardInfo class - Part 1: processGuess
	-----------------------------------------------------------------------*/
	void TestBoardInfo1(){
	
		testHeader("BoardInfo class: processGuess");

		Board opponentBoard = new Board(5, 225, 50, window);
		
		/* notice - data is in column-first order here */	                                ;
		opponentBoard.b = new int[][]{ {0,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {3,1,0,2,0},
	                                   {0,1,0,0,0} };

		opponentBoard.display();
		
		BoardInfo opponentBinfo = new BoardInfo(opponentBoard);
				

		println("Testing processGuess with opponent board");
		
		/* repeated hit */
		expected(REPEAT);
		actual(opponentBinfo.processGuess(1, 0));

		/* new hit */
		expected(HIT);
		actual(opponentBinfo.processGuess(0, 1));

		/* new miss */
		expected(MISS);
		actual(opponentBinfo.processGuess(1, 2));

		/* repeated miss */
		expected(REPEAT);
		actual(opponentBinfo.processGuess(0, 3));

		opponentBinfo.processGuess(1, 1);
		opponentBinfo.processGuess(2, 1);
		opponentBinfo.processGuess(3, 1);

		/* should have hit all ships by now */
		expected(WIN);
		actual(opponentBinfo.processGuess(4, 1));


		println("Print opponent board - size 5:\n");
		println(opponentBoard);

	}
	
	/*----------------------------------------------------------------------- 
	 Test BoardInfo class - Part 2: initMyReply
	-----------------------------------------------------------------------*/
	void TestBoardInfoInitMyReply(){
	
		testHeader("BoardInfo class: initMyReply");

		Board opponentBoard = new Board(5, 225, 50, window);
		
		
		BoardInfo opponentBinfo = new BoardInfo(opponentBoard);
		opponentBinfo.initMyReply();
		opponentBoard.display();
		pressReturn("Initial board shown");

		println("Testing processGuess with opponent board");
		
		/* repeated hit */
		expected(REPEAT);
		actual(opponentBinfo.processGuess(1, 0));

		/* new hit */
		expected(HIT);
		actual(opponentBinfo.processGuess(0, 1));

		/* new miss */
		expected(MISS);
		actual(opponentBinfo.processGuess(1, 2));

		/* repeated miss */
		expected(REPEAT);
		actual(opponentBinfo.processGuess(0, 3));

		opponentBinfo.processGuess(1, 1);
		opponentBinfo.processGuess(2, 1);
		opponentBinfo.processGuess(3, 1);

		/* should have hit all ships by now */
		expected(WIN);
		actual(opponentBinfo.processGuess(4, 1));


		println("Print opponent board - size 5:\n");
		println(opponentBoard);

	}
	
	/*----------------------------------------------------------------------- 
	 Test BoardInfo class - Part 3: initMyGuess and processResult
	-----------------------------------------------------------------------*/
	void TestBoardInitMyGuess(){
	
		testHeader("BoardInfo class: initMyGuess and processResult");

		Board opponentBoard = new Board(5, 225, 50, window);
		

		opponentBoard.display();
		
		BoardInfo opponentBinfo = new BoardInfo(opponentBoard);
				
		/* notice - data is in column-first order here */	                                ;
		opponentBinfo.initMyGuess();

		println("Testing processResult with opponent board");
		
		/* first hit */
		expected(OK);
		actual(opponentBinfo.processResult(1, 0, HIT));

		/* repeat hit */
		expected(OK);
		actual(opponentBinfo.processResult(1, 0, REPEAT));

		/* new miss */
		expected(OK);
		actual(opponentBinfo.processResult(1, 2, MISS));

		/* repeated miss */
		expected(OK);
		actual(opponentBinfo.processResult(1, 2, REPEAT));

		opponentBinfo.processResult(1, 1, HIT);
		opponentBinfo.processResult(2, 1, HIT);
		opponentBinfo.processResult(3, 1, HIT);

		/* should have hit all ships by now */
		expected(WIN);
		actual(opponentBinfo.processResult(3, 0, HIT));


		println("Print opponent board - size 5:\n");
		println(opponentBoard);

	}
	
	/*----------------------------------------------------------------------- 
	 Test Player class
	-----------------------------------------------------------------------*/
	void TestBoardPlayer(){
	
		Board playerBoard = new Board(10, 25, 50, window);
		
		Player   player   = 
			new Player  (new BoardInfo(playerBoard),   
						 new IOConsoleChannel());
			
		player.player.initialize();
		player.player.board.display();
		
		println("Starting playTurn()");
		println("Protocol:");
		
		println("Player makes a guess: guess(x y) ");
		println("Respond with one digit: MISS = 2, HIT = 3, REPEAT = 5");
		println("Player resonds with either 'Your turn' or 'I win'"); 
		
		while(console.confirm("Another turn", true)){
		
			player.playTurn();
			println("Finished one turn.");
		}
		
		println("\n TEST COMPLETED");

	}
	
	/*----------------------------------------------------------------------- 
	 Test Opponent class
	-----------------------------------------------------------------------*/
	void TestBoardOpponent(){
	
		Board opponentBoard = new Board(10, 225, 50, window);
		
		Opponent opponent   = 
			new Opponent  (new BoardInfo(opponentBoard),   
						 new IOConsoleChannel());
			
		opponent.opponent.initialize();
		opponent.opponent.board.display();
		
		println("Starting playTurn()");
		println("Protocol:");
		
		println("Opponent reads a guess: guess(x y) ");
		println("Opponent responds with one digit:");
		println("MISS = 2, HIT = 3, WIN = 4, REPEAT = 5");
		println("Opponent reads player's message: 'Your turn' or 'I win'"); 
		
		while(console.confirm("Another turn", true)){
		
			opponent.playTurn();
			println("Finished one turn.");
		}
		
		println("\n TEST COMPLETED");

	}
	

	/*----------------------------------------------------------------------- 
	 Test Administrator class: Starter variant
	-----------------------------------------------------------------------*/
    void TestBattleShipsStarter(){
    	Administrator admin = 
    		new Administrator(10, 
							  new IOConsoleChannel(),
							  window,
							  true);
							  
		println("Test Administrator class: Starter variant");		
		println("Game is initialized");
		admin.openGame();
    }

	/*----------------------------------------------------------------------- 
	 Test Administrator class: Responder variant
	-----------------------------------------------------------------------*/
    void TestBattleShipsResponder(){
    	Administrator admin = 
    		new Administrator(10, 
							  new IOConsoleChannel(),
							  window,
							  false);
    											
		println("Test Administrator class: Responder variant");
		println("Game is initialized");
		admin.openGame();
    }

	/*----------------------------------------------------------------------- 
	 Test Administrator class: Starter variant with socket
	-----------------------------------------------------------------------*/
    void TestSockerServer(){
    	Administrator admin = 
    		new Administrator(10, 
							  new SocketChannel("localhost"),
							  window,
							  true);
							  
		println("Test Administrator class: Starter variant");		
		println("Game is initialized");
		admin.openGame();
    }

    
}

