/* 
Opponent.java  22 May 2003 */


import java.awt.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.awt.*;
import java.math.*;
import java.util.*;

public class Opponent implements BattleshipConstants, ConsoleAware{
	 	
	
	/*----------------------------------------------------------------------- 
	 Member data
	-----------------------------------------------------------------------*/
	/* the class to process game logic for the opponent */
	public BoardInfo opponent;
	
	/* the io channel for communication */
	IOChannel io;
			
	/*----------------------------------------------------------------------- 
	 Constructors
	------------------------------------------------------------------------- */
	public Opponent(BoardInfo _boardInfo, IOChannel _io){
		
		this.io    = _io;
		opponent = _boardInfo;
	}
                
	/*----------------------------------------------------------------------- 
	 Initialize 
	-----------------------------------------------------------------------*/
    public void initialize(){
    	opponent.initialize();
    }
    
	/*----------------------------------------------------------------------- 
	 Make guesses 
	-----------------------------------------------------------------------*/
    public int playTurn(){

		console.out.println("Opponent's turn");
		        
    	/* read guess-message from the player */
    	Point p = getPoint(io.read());
    	
    	/* process player's guess */
    	int reply = opponent.processGuess(p.x, p.y);
    	
    	/* write reply-to-guess-message to the player */
    	io.write("" + reply);
    	
    	/* read your-turn-message from the player */
    	String ready = io.read();
    	
    	if (ready.equals("I win"))
    		return WIN;
    	else
    		return OK;    	
    }
    
	/*----------------------------------------------------------------------- 
	 Extract Point data from "guess(3 10)" message
	-----------------------------------------------------------------------*/
	public Point getPoint(String s){

		StringTokenizer st = new StringTokenizer(s, "( )");
		
		/* default values toguess for ill-formed guess */
		int x = 1;	
		int y = 1;
		String junk;
		
		/* discard the beginning of the message */
		if (st.hasMoreTokens())
			junk = st.nextToken();
		else
			console.out.println("Bad guess");
		
		/* process the first number */
		if (st.hasMoreTokens())
			x = getNumber(st.nextToken());
		else
			console.out.println("Bad guess");
		
		/* process the second number */
		if (st.hasMoreTokens())
			y = getNumber(st.nextToken());
		else
			console.out.println("Bad guess");
			
		return new Point(x, y);
	}
	
	/*----------------------------------------------------------------------- 
	 Convert String to a number
	-----------------------------------------------------------------------*/
	public int getNumber(String input){
		
		if (isNumber(input))
			return (new Integer(input)).intValue();
		else {
			console.out.println("Invalid response - not a number");
			return REPEAT;
		}
			
	}

	/*----------------------------------------------------------------------- 
	 Verify that String represents a number
	-----------------------------------------------------------------------*/
	public boolean isNumber(String input){
		
		StringTokenizer st = new StringTokenizer(input, "0123456789");
		return (! (st.hasMoreTokens()));
	}

	/*----------------------------------------------------------------------- 
	 Print all member data
	-----------------------------------------------------------------------*/
	public String toString(){
		return ("new " + getClass().getName() + "(" +
		        this.opponent  + ")");
	}
}

