/*
 * @(#GuessView.java 24 May 2003
 *
 *   Viera Proulx      vkp@ccs.neu.edu
 */

import edu.neu.ccs.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.geom.*;
import java.text.NumberFormat;
import java.text.DecimalFormat;
import javax.swing.*;

/**
 * View for input of Battleship guess.
 */
public class GuessView
    implements JPTConstants {
        
    /////////////////
    // Member Data //
    /////////////////
    
    /** Point object for the guess */    
    protected Point p;
    
    /** the size of the battleship board */
    protected int size;
    
	/** The view to be used in input GUIs */
	public Display gView = new Display();
	
    /** Display field for the row. */
    protected TextFieldView rowTFV = 
                new TextFieldView("",
                        	      "Please enter an integer:",
                        	      "row error",
                        	      80);
	             

    /** Display field for the column. */
    protected TextFieldView colTFV = 
                new TextFieldView("",
                        	      "Please enter an integer:",
                        	      "column error",
                        	      80);
	             
	             	             
    /** A filter to guarantee the input is within given range */
    StringableFilter boundsFilter;

    public GuessView(int _size) {

		/* record the infromation about this guess */
   	    this.p = new Point();
   	    
   	    /* record the size of the board */
   	    this.size = _size;

    	/* set up the array bounds filter */
    	boundsFilter = new RangeFilter.Long(0, this.size);

 		// create Display with title "Guess"
		gView = new Display(createDisplay(), null, "Guess");
    }
    
    //////////////////////////////////
    // Helpers for the Constructors //
    //////////////////////////////////
    
    /**
     * Construct a table panel display for one person, containing
     * three text field views
     */
    protected TablePanel createDisplay() {
    		            
        /* compose the TFVs into one panel */
        TablePanel guessDisplay = new TablePanel(new Object[][]{
            {"Row:   ", rowTFV},
            {"Column:", colTFV},
            }, VERTICAL, 5, 5);
        
        return guessDisplay;        	
    }
    
    /* set the view state from the current state of the point */
    public void setViewState(){
    
        rowTFV.setViewState("" + p.x);
        colTFV.setViewState("" + p.y);
    }
    
    /* get the guess Point object from this view */
    public Point getGuess(){
        p.x = rowTFV.demandInt(boundsFilter);
        p.y = colTFV.demandInt(boundsFilter);
        return p;
    }

}