/*
 * @(#)ChGUIReadGuess.java  23 May 2003
 *
 * @author Viera K. Proulx
 */

import java.awt.*;

import edu.neu.ccs.gui.*;

/** An input channel to return Battleship guess from GUI input. */
class ChGUIReadGuess implements ChGuessInput{
    
    /*--------------------------------------------------------------
     Member data
     *------------------------------------------------------------*/

    /* the view for the input */
    public GuessView gView;
    
    /* the size of the battleship board */
    public int size;
    
    /*--------------------------------------------------------------
     Constructor
     *------------------------------------------------------------*/
    public ChGUIReadGuess(int _size){
    
    	/* record the size of the board */
    	this.size = _size;
    	
    	/* create the view for the guess */
        gView = new GuessView(this.size);
            
        /* install the views in a new table panel */
        GeneralDialog.showOKDialog(gView.gView,
                                  "Guess Selection");
                                  

    }
    
    /*--------------------------------------------------------------
     Methods
     *------------------------------------------------------------*/

    /* read values for one guess from the GUI */
    public Point read(){
        return gView.getGuess();
    }
    
}
