/* 
BoardInfo.java  22 May 2003 */


import java.awt.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;

public class BoardInfo implements ConsoleAware,
								  BattleshipConstants{
	 	
	/*----------------------------------------------------------------------- 
	 Member data
	-----------------------------------------------------------------------*/
	/* board to record theplay and display the results */
	public Board board;
	
	/* method for selecting the guess */
	public int selectChoice = 0;
	
	/* total number of turns takes */
	int noTurns = 0;
	
	/* total number of places taken by ships */
	int noShips = 0;
	
	/* total number of hits so far */
	int noHits = 0;
	
	/* size of the board used in this game */
	int size = 10;
		
	/*----------------------------------------------------------------------- 
	 Constructors
	-----------------------------------------------------------------------*/
	public BoardInfo(Board _board, int choice){
		
		this.board = _board;
		this.selectChoice = choice;
		noShips = countShips();
	}
                
	public BoardInfo(Board _board){
		
		this(_board, 0);
	}
                
	/*----------------------------------------------------------------------- 
	 Initializer
	-----------------------------------------------------------------------*/
	/* initialize the board in the given size for the opponent */
	/* currently assumes size is 10 - fixes ship's locations */
	public void initialize(){
		
		board.b[0][3] = SHIP;
		board.b[0][4] = SHIP;
		
		/*
		board.b[2][5] = SHIP;
		board.b[2][6] = SHIP;
		board.b[4][8] = SHIP;
		board.b[5][1] = SHIP;
		board.b[5][2] = SHIP;
		board.b[5][3] = SHIP;
		board.b[5][4] = SHIP;
		board.b[5][8] = SHIP;
		board.b[6][8] = SHIP;
		board.b[7][5] = SHIP;
		board.b[8][5] = SHIP;
		board.b[9][5] = SHIP;
		*/
		
		noShips = 2;
	}
                
	/* initialize the board in the given size for guessing */
	/* currently assumes size is 5 - no ship locations known */
	public void initMyGuess(){
		
		board.b = new int[][]{ {0,0,0,0,0},
							   {0,0,0,0,0},
							   {0,0,0,0,0},
							   {0,0,0,0,0},
							   {0,0,0,0,0} };
		
		noShips = 5;
	}
                
	/* initialize the board in the given size for the opponent */
	/* currently assumes size is 5 - fixes ship's locations */
	public void initMyReply(){
		
		board.b = new int[][]{ {0,1,0,2,0},
                               {3,1,0,2,0},
                               {3,1,0,2,0},
                               {3,1,0,2,0},
                               {0,1,0,0,0} };
		
		noShips = countShips();
	}
                
	/*----------------------------------------------------------------------- 
	 Count ships - if the constructor receives a board 
	-----------------------------------------------------------------------*/
	protected int countShips(){
		
		int count = 0;
		this.size = board.b.length;
		
		for (int row = 0; row < this.size; row++)
			for (int col = 0; col < this.size; col++)
				if (board.b[row][col] == SHIP)
					count = count + 1;
		return count;
	}	

	/*----------------------------------------------------------------------- 
	 Reply to user's guess
	-----------------------------------------------------------------------*/
    int processGuess(int row, int col){
    
    	noTurns++;
    	
		if (board.b[row][col] == SHIP){
			
			board.b[row][col] = HIT;	/* record the hit */			
			noHits++;					/* count the hit */

			if (noShips == noHits)		/* check if win */
				return signal(WIN);
			else
				return signal(HIT);			
		}
		
		else if (board.b[row][col] == WATER){
		
			board.b[row][col] = MISS;	/* record the miss */			
			return signal(MISS);		
		}
		
		else if (  (board.b[row][col] == HIT)
		   || (board.b[row][col] == MISS) ){
		   
		   return signal(REPEAT);		
		}
		
	  	else return signal(REPEAT);				
    }

	/*----------------------------------------------------------------------- 
	 Helper method to display the board before returning
	-----------------------------------------------------------------------*/
    protected int signal(int value){
    	board.display();
    	return value;
    }
    
	/*----------------------------------------------------------------------- 
	  Make the next guess
	-----------------------------------------------------------------------*/
    public Point selectGuess(){
    	
    	if (selectChoice == 0)
    		return GUISelect();
    	if (selectChoice == 1)
    		return randomSelect();
    	if (selectChoice == 2)
    		return consoleSelect();    	
    	return consoleSelect();    	
    }
    
    public Point GUISelect(){
    	
    	ChGUIReadGuess guessIn = new ChGUIReadGuess(size);
    	return new Point(guessIn.read());    	
    }
    
    public Point randomSelect(){
    	
    	return new Point(MathUtilities.randomInt(0, size - 1), 
    					 MathUtilities.randomInt(0, size - 1));    	
    }
    
    public Point consoleSelect(){
    	
    	int row = console.in.demandInt("Guess the row:");
    	int col = console.in.demandInt("Guess the column:");
    	
    	while (! ((row >= 0) && (row < size) && 
    	          (col >= 0) && (col < size))){
    		console.out.println("Incorrect guess - try again.");
    		row = console.in.demandInt("Guess the row:");
    		col = console.in.demandInt("Guess the column:");
    	}
    	
    	return new Point(row, col);
    }

        
	/*----------------------------------------------------------------------- 
	 Record opponent's response
	-----------------------------------------------------------------------*/
    int processResult(int row, int col, int result){
    
    	noTurns++;
    	
		if ((result == HIT) || (result == WIN)){
			
			board.b[row][col] = HIT;	/* record the hit */			
			noHits++;					/* count the hit */

			if (noShips == noHits)		/* check if win */
				return signal(WIN);
			else 
				return signal(OK);
		}
		
		if (result == MISS){		
			board.b[row][col] = MISS;		/* record the miss */			
			return signal(OK);		
		}
		
		if (result == REPEAT){		   
		   System.out.println("Repeated guess - foolish me!");
		   return signal(OK);		
		}
		
		return signal(REPEAT);		
    }
    
	/*----------------------------------------------------------------------- 
	 Print all member data
	-----------------------------------------------------------------------*/
	public String toString(){
		return ("new " + getClass().getName() + "(" +
		        this.noTurns  + ", "  + 
		        this.noShips  + ", "  + 
		        this.noHits   +  "\n" +
		        this.board    +  ")");
	}
}

