/* 
Board.java  22 May 2003 */


import java.awt.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;
import java.awt.geom.*;		// to get Graphics2D functionality

public class Board implements BattleshipConstants{
	 	
	
	/*----------------------------------------------------------------------- 
	 Member data
	-----------------------------------------------------------------------*/
	/* the board to be displayed */
	/* !!!!!! This is in transpose (columns first order !!!!!!! */
	public int b[][] = new int[][]{ {0,0,0,0,0,0,0,0,0,0},
	                                {0,0,0,0,0,0,0,0,0,0},
	                                {0,0,0,0,0,0,0,0,0,0},
	                                {0,0,0,0,0,0,0,0,0,0},
	                                {0,0,0,0,0,0,0,0,0,0},
	                                {0,0,0,0,0,0,0,0,0,0},
	                                {0,0,0,0,0,0,0,0,0,0},
	                                {0,0,0,0,0,0,0,0,0,0},
	                                {0,0,0,0,0,0,0,0,0,0},
	                                {0,0,0,0,0,0,0,0,0,0} };
		
	/* size of the board used in this game */
	int size = 10;
	
	/* location for the display */
	int rowOffset = 100;
	int colOffset = 100;
	
	/* the graphics window for the display of the board */
	BufferedPanel window;
		
	/*----------------------------------------------------------------------- 
	 Constructors
	------------------------------------------------------------------------- */
	public Board(int n, int colOff, int rowOff, 
	                    BufferedPanel _window){
		
		if ((n > 0) && (n <= 10))
			this.size = n;
			
		colOffset = colOff;
		rowOffset = rowOff;
		
		window = _window;
	}
                
	/*----------------------------------------------------------------------- 
	 Methods
	------------------------------------------------------------------------- */

	/*----------------------------------------------------------------------- 
     Display the board in the graphics window 
	------------------------------------------------------------------------- */    
    public void display(){
    
    	/* set the color code for board squares */
    	Color[] colors = new Color[]{Color.blue,	// WATER
    	                             Color.black,	// SHIP
    	                             Color.yellow,	// MISS
    	                             Color.red};	// HIT
    	                             
        if (window == null)
            return;
            
        // get graphics context and set the color
        Graphics2D G = window.getBufferGraphics();
        
        for (int row = 0; row < size; row++)
        	for (int col = 0; col < size; col++){
        	
        		G.setPaint(colors[b[row][col]]);
        
		        // paint the rectangle
		        Rectangle2D.Double R = 
		            new Rectangle2D.Double(colOffset + 15 * col,
		            				       rowOffset + 15 * row, 
		                                   14, 
		                                   14); 

		        G.fill(R); 
		    }
		           
        window.repaint();
    }
        
	/*----------------------------------------------------------------------- 
	 Print all member data
	-----------------------------------------------------------------------*/
	public String toString(){
		return ("new " + getClass().getName() + "(" +
		        this.rowOffset  + ", " + 
		        this.colOffset  + ", " + 
		        this.size       +  "\n" +
		        toString(b) + ")");
	}
	
	/* helper to print the ocntents of the board array */
	protected String toString(int[][] board){

		String s = "new int[][]{\n{";
		
        for (int row = 0; row < size; row++){
        	for (int col = 0; col < size - 1; col++)
        		s = s + b[row][col] + ", ";

			/* replace the last comma 
			   with close curly and newline */
        	s = s + b[row][size - 1] + "},\n{";
        }
        
        /* replace the last comma and newline 
           with extra curly and newline */
        s = (s.substring(0, s.length() - 3)) + "}\n";
		
		return s;
	}
}

