/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.util.StringTokenizer;

public class Opponent
implements BattleshipConstants {
    public BoardInfo opponent;
    IOChannel io;

    public Opponent(BoardInfo _boardInfo, IOChannel _io) {
        this.io = _io;
        this.opponent = _boardInfo;
    }

    public void initialize() {
        this.opponent.initialize();
    }

    public int playTurn() {
        Point p = this.getPoint(this.io.read());
        int reply = this.opponent.processGuess(p.x, p.y);
        this.io.write(String.valueOf(reply));
        String ready = this.io.read();
        if (ready.equals("I win")) {
            return 4;
        }
        return 0;
    }

    public Point getPoint(String s) {
        StringTokenizer st = new StringTokenizer(s, "( )");
        int x = 1;
        int y = 1;
        if (st.hasMoreTokens()) {
            String junk = st.nextToken();
        } else {
            System.out.println("Bad guess");
        }
        if (st.hasMoreTokens()) {
            x = this.getNumber(st.nextToken());
        } else {
            System.out.println("Bad guess");
        }
        if (st.hasMoreTokens()) {
            y = this.getNumber(st.nextToken());
        } else {
            System.out.println("Bad guess");
        }
        return new Point(x, y);
    }

    public int getNumber(String input) {
        if (this.isNumber(input)) {
            return new Integer(input);
        }
        System.out.println("Invalid response - not a number");
        return 5;
    }

    public boolean isNumber(String input) {
        StringTokenizer st = new StringTokenizer(input, "0123456789");
        return st.hasMoreTokens() ^ true;
    }

    public String toString() {
        return "new " + this.getClass().getName() + "(" + this.opponent + ")";
    }
}

