/*
 * Decompiled with CFR 0.152.
 */
import edu.neu.ccs.console.ConsoleAware;
import java.awt.Point;

public class BoardInfo
implements ConsoleAware,
BattleshipConstants {
    public Board board;
    int noTurns = 0;
    int noShips = 0;
    int noHits = 0;
    int size = 10;

    public BoardInfo(Board _board) {
        this.board = _board;
        this.size = this.board.b.length;
    }

    public void initialize() {
        this.board.b[0][3] = 1;
        this.board.b[0][4] = 1;
        this.board.b[2][5] = 1;
        this.board.b[2][6] = 1;
        this.board.b[4][8] = 1;
        this.board.b[5][1] = 1;
        this.board.b[5][2] = 1;
        this.board.b[5][3] = 1;
        this.board.b[5][4] = 1;
        this.board.b[5][8] = 1;
        this.board.b[6][8] = 1;
        this.board.b[7][5] = 1;
        this.board.b[8][5] = 1;
        this.board.b[9][5] = 1;
        this.noShips = 14;
    }

    int processGuess(int row, int col) {
        ++this.noTurns;
        if (this.board.b[row][col] == 1) {
            this.board.b[row][col] = 3;
            ++this.noHits;
            if (this.noShips == this.noHits) {
                return this.signal(4);
            }
            return this.signal(3);
        }
        if (this.board.b[row][col] == 0) {
            this.board.b[row][col] = 2;
            return this.signal(2);
        }
        if (this.board.b[row][col] == 3 || this.board.b[row][col] == 2) {
            return this.signal(5);
        }
        return this.signal(5);
    }

    protected int signal(int value) {
        this.board.display();
        return value;
    }

    public Point selectGuess() {
        int row = ConsoleAware.console.in.demandInt("Guess the row:");
        int col = ConsoleAware.console.in.demandInt("Guess the column:");
        while (row <= 0 || row > this.size || col <= 0 || col > this.size) {
            ConsoleAware.console.out.println("Incorrect guess - try again.");
            row = ConsoleAware.console.in.demandInt("Guess the row:");
            col = ConsoleAware.console.in.demandInt("Guess the column:");
        }
        return new Point(col - 1, row - 1);
    }

    int processResult(int row, int col, int result) {
        ++this.noTurns;
        if (result == 3) {
            this.board.b[row][col] = 3;
            ++this.noHits;
            if (this.noShips == this.noHits) {
                return this.signal(4);
            }
        }
        if (result == 2) {
            this.board.b[row][col] = 2;
            return this.signal(0);
        }
        if (result == 5) {
            System.out.println("Repeated guess - foolish me!");
            return this.signal(0);
        }
        return this.signal(5);
    }

    public String toString() {
        return "new " + this.getClass().getName() + "(" + this.noTurns + ", " + this.noShips + ", " + this.noHits + ")";
    }
}

