/* @(#)TestSuite.java 1.0  6 April 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.codec.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.jpf.*;
import edu.neu.ccs.parser.*;
import edu.neu.ccs.pedagogy.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.util.*;
import java.text.*;
import java.math.*;
import javax.swing.*;
import java.lang.reflect.*;
import java.net.URL;

public class TestSuite extends JPFalt 
{
    public static void main(String[] args) { new TestSuite(); }
    
    /*--------------------------------------------------------
     Test the edge list
     -------------------------------------------------------*/
	public void TestEdgeList(){
		
		println("\nTesting the edge list\n");
		
		String s1 = "Hello";
		String s2 = "Goodbye";
		String s3 = "Ciao";
		String s4 = "GutenTag";
		String s5 = "DobryDen";
		
		Edge e1 = new Edge(s1, s2, 5);
		Edge e2 = new Edge(s2, s3, 10);
		Edge e3 = new Edge(s3, s4, 15);
		Edge e4 = new Edge(s4, s5, 20);
		Edge e5 = new Edge(s5, s1, 25);
		
		AnEdgeList eList0 = new EmptyEdgeList();
		AnEdgeList eList1 = new ConsEdgeList(e1, eList0);
		AnEdgeList eList2 = new ConsEdgeList(e3,
								new ConsEdgeList(e4,
									new ConsEdgeList(e5,
										eList0)));
		println(eList0);
		println(eList1);
		println(eList2);								
										
		AnEdgeList eList3 = eList2.addEdge(e2);
		println(eList3);
		
		AnEdgeList eList4 = eList0.addEdge(e1);
		println(eList4);
	
	}

    /*--------------------------------------------------------
     Test the nodes
     -------------------------------------------------------*/
	public void TestNodes(){

		println("\nTesting the nodes and their edge lists\n");
		
		String s1 = "Hello";
		String s2 = "Goodbye";
		String s3 = "Ciao";
		String s4 = "GutenTag";
		String s5 = "DobryDen";
		
		Edge e1 = new Edge(s1, s2, 5);
		Edge e2 = new Edge(s2, s3, 10);
		Edge e3 = new Edge(s3, s4, 15);
		Edge e4 = new Edge(s4, s5, 20);
		Edge e5 = new Edge(s5, s1, 25);
		
		Node n1 = new Node(s1);
		Node n2 = new Node(s2);
		Node n3 = new Node(s3);
		Node n4 = new Node(s4);
		
		n1.addEdge(e1);
		n2.addEdge(e2);
		n3.addEdge(e3);
		n4.addEdge(e4);

		println("\nOne edge for each:");
		println(n1);
		println(n2);
		println(n3);
		println(n4);

		n1.addEdge(e5);
		n2.addEdge(e1);
		n3.addEdge(e2);		
		n4.addEdge(e3);
		
		println("\nTwo edges for each:");
		println(n1);
		println(n2);
		println(n3);
		println(n4);
		
		
		AnEdgeList eList0 = new EmptyEdgeList();
		AnEdgeList eList1 = new ConsEdgeList(e1, eList0);
		AnEdgeList eList2 = new ConsEdgeList(e3,
								new ConsEdgeList(e4,
									new ConsEdgeList(e5,
										eList0)));
										
		AnEdgeList eList3 = eList2.addEdge(e2);
		
		AnEdgeList eList4 = eList0.addEdge(e1);
		println(eList4);
		
		println("\nGraphs\n");
		
		Graph g = new Graph();
		println(g);
		
		g.addNode(n1);
		println(g);
		
		g.addNode(n2);
		println(g);
		
		g.addNode(n3);
		println(g);
			
	}

    /*--------------------------------------------------------
     Test the graph
     -------------------------------------------------------*/
	public void TestGraph(){

		println("\nTesting the graph\n");
		
		String s1 = "N1";
		String s2 = "N2";
		String s3 = "N3";
		String s4 = "N4";
		String s5 = "N5";
		
		Edge e1 = new Edge(s1, s2, 5);
		Edge e2 = new Edge(s2, s3, 10);
		Edge e3 = new Edge(s3, s4, 15);
		Edge e4 = new Edge(s4, s5, 20);
		Edge e5 = new Edge(s5, s1, 25);
		
		Node n1 = new Node(s1);
		Node n2 = new Node(s2);
		Node n3 = new Node(s3);
		Node n4 = new Node(s4);
		
		println("\nGraphs\n");
		
		Graph g = new Graph();
		println("\nEmpty graph: " + g);
		
		g.addNode(n1);
		println("\nGraph with one node: " + g);
		
		g.addNode(n2);
		println("\nGraph with two nodes: " + g);
		
		g.addNode(n3);
		println("\nGraph with three nodes: " + g);
		
		g.addEdge(e1);
		println("\nGraph with three nodes and one edge:\n " + g);
			
		g.addEdge(e2);
		println("\nGraph with three nodes and two edges:\n " + g);
			
		g.addEdge(e3);
		println("\nGraph with three nodes and two edges:\n " + g);
			
		g.addEdge(e5);
		println("\nGraph with three nodes and two edges:\n " + g);
			
	}
    /*--------------------------------------------------------
     Test the graph with Data
     -------------------------------------------------------*/
	public void TestGraphData(){

		println("\nTesting the graph\n");
		
		Data s1 = new Data("N1", 100, 200);
		Data s2 = new Data("N2", 200, 150);
		Data s3 = new Data("N3", 300, 300);
		Data s4 = new Data("N4", 250, 100);
		Data s5 = new Data("N5", 100, 250);
		
		Edge e1 = new Edge(s1, s2, 5);
		Edge e2 = new Edge(s2, s3, 10);
		Edge e3 = new Edge(s3, s4, 15);
		Edge e4 = new Edge(s4, s5, 20);
		Edge e5 = new Edge(s5, s1, 25);
		
		Node n1 = new Node(s1);
		Node n2 = new Node(s2);
		Node n3 = new Node(s3);
		Node n4 = new Node(s4);
		
		println("\nGraphs\n");
		
		Graph g = new Graph();
		println("\nEmpty graph: " + g);
		
		g.addNode(n1);
		println("\nGraph with one node: " + g);
		
		g.addNode(n2);
		println("\nGraph with two nodes: " + g);
		
		g.addNode(n3);
		println("\nGraph with three nodes: " + g);
		
		g.addNode(n4);
		println("\nGraph with four nodes: " + g);
		
		g.addEdge(e1);
		println("\nGraph with three nodes and one edge:\n " + g);
			
		g.addEdge(e2);
		println("\nGraph with three nodes and two edges:\n " + g);
			
		g.addEdge(e3);
		println("\nGraph with three nodes and three edges:\n " + g);
			
		g.addEdge(e5);
		println("\nGraph with three nodes and four edges:\n " + g);

		println("\nDisplay the graph \n");
		GraphDisplay gd = new GraphDisplay(g, window);
		
		//gd.showNode((ILocatable)n3.data);
		
		//gd.showEdge(e3);
		
		gd.showGraph();	
		
		println("Done with graph display.");		
	}

    /*--------------------------------------------------------
     Test the graph
     -------------------------------------------------------*/
	public void TestStack(){

		println("\nTesting the stack\n");
		
		String s1 = "N1";
		String s2 = "N2";
		String s3 = "N3";
		String s4 = "N4";
		String s5 = "N5";
		
		Stack st = new Stack();
		
		expected(true);
		actual(st.isEmpty());
		
		st.insert(s1);
		st.insert(s2);
		st.insert(s3);
		st.insert(s4);
		
		expected(false);
		actual(st.isEmpty());
		
		println("\nStack with four items:\n");
		println("" + st);
		
		String s9 = (String)st.remove();
		String s8 = (String)st.remove();
		
		println(s9 + " and " + s8 + " removed from stack");
	
		println("\nStack with two items:\n");
		println("" + st);
		
		String s = (String)st.remove();
		s = (String)st.remove();
	
		expected(true);
		actual(st.isEmpty());
	}
}