/* @(#)Stack.java  16 May 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.codec.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.jpf.*;
import edu.neu.ccs.parser.*;
import edu.neu.ccs.pedagogy.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.util.*;
import java.text.*;
import java.math.*;
import javax.swing.*;
import java.lang.reflect.*;
import java.net.URL;

public class Stack implements IQueue{
    
    /*--------------------------------------------------------
     Member Data
     -------------------------------------------------------*/
	/* The stack of the edges */
	Object[] edges;
	
	/* The size of the stack */
	int size;
	
    /*--------------------------------------------------------
     Constructor
     -------------------------------------------------------*/
	public Stack(){
		this.edges = new Object[100];
		this.size = 0;
	};
	
    /*--------------------------------------------------------
     Methods
     -------------------------------------------------------*/
	/* determine whether the stack is empty */
	public boolean isEmpty(){
		return this.size == 0;
	}
	
	/* determine whether the stack is full */
	public boolean isFull(){
		return this.size == this.edges.length;
	}
	
	/* insert an object on top of the stack */
	public boolean insert(Object obj){
		
		/* make sure there is room to insert */
		if (this.size < this.edges.length){
		
			edges[size] = obj;
			size++;
			return true;
		}
		else return false;
	}
	
	/* remove an object from the top of the list */
	public Object remove(){
	
		/* make sure stack is not empty */
		if (size > 0){
		
			size = size - 1;
			Object obj = edges[size];
			return obj;			
		}
		else return null;
	}
	
		
    /*--------------------------------------------------------
     Method to print member data as String
     -------------------------------------------------------*/
	public String toString(){
		return ("" + this.getClass().getName() +
				this.size + ", " +
				toString(this.edges) + ")");
	}
	
	/* helper method to pring the array of objects */
	public String toString(Object[] obj){
		
		if (size > 0){
			String s = "[" + obj[0];
			for (int i = 1; i < size; i++){
			
				s = s + ", " + obj[i];
			}
			return (s + "]");
		}
		else
			return "**";
	}

}