/* @(#)Node.java  16 May 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.codec.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.jpf.*;
import edu.neu.ccs.parser.*;
import edu.neu.ccs.pedagogy.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.util.*;
import java.text.*;
import java.math.*;
import javax.swing.*;
import java.lang.reflect.*;
import java.net.URL;

public class Node implements ILocatable{

	/*------------------------------------------------------- 
	----------- The objects in this class do not have to
	----------- implement ILocatable - but if they do, then
	----------- GraphDisplay can be used to show the graph
	----------- in the given BufferedPanel window
	----------- The feature to display the node label
	----------- is not yet implemented. --------------------*/    
    /*--------------------------------------------------------
     Member Data
     -------------------------------------------------------*/
	/* contents of the graph node */
	public Object data;
	
	/* list of adjacent edges */
	public AnEdgeList edges;
	
    /*--------------------------------------------------------
     Constructor
     -------------------------------------------------------*/
	/* construct a new node with no neighbors */
	public Node(Object obj){
		data = obj;
		edges = new EmptyEdgeList();
	}

    /*--------------------------------------------------------
     Methods
     -------------------------------------------------------*/
	/* add a new edge to the edge list */
	public void addEdge(Edge anEdge){
		
		/* make sure this node is the start or finish node */
		if ((anEdge.start.equals(data))
			|| (anEdge.finish.equals(data)))
			edges = edges.addEdge(anEdge);
	}
	
    /*--------------------------------------------------------
     Methods to implement ILocatable, when needed
     -------------------------------------------------------*/
	/* the x-y coordinate for this object */
	public Point getLocation(){
		return ((ILocatable)data).getLocation();
	}
	
	/* the label to display for this object */
	public String getLabel(){
		return ((ILocatable)data).getLabel();
	}

    /*--------------------------------------------------------
     Method to print member data as String
     -------------------------------------------------------*/
	public String toString(){
		return ("new (" + this.getClass().getName() + "(" +
				this.data + ": " +
				this.edges + ")");
	}

}