/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern:
        iterator for a list of edges 
*/

class ListRange implements IRange {

    /*-------------------------------------------------------- 
     Member data
     *------------------------------------------------------*/
    AnEdgeList ptr; /* reference to this list */
    
    /*-------------------------------------------------------- 
     Constructor
     *------------------------------------------------------*/
    ListRange(AnEdgeList aList) { this.ptr = aList; }
        
    /*--------------------------------------------------------
     Methods to implement the IRange interface
     *------------------------------------------------------*/

    public void next() {
        this.ptr = ((ConsEdgeList)this.ptr).rest; 
    }


    public Object current() {
        return ((ConsEdgeList)this.ptr).first; 
    }
    
    public boolean hasMore() {
        return (this.ptr instanceof ConsEdgeList); 
    }
}
        
