/* @(#)GraphDisplay.java  16 May 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.codec.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.jpf.*;
import edu.neu.ccs.parser.*;
import edu.neu.ccs.pedagogy.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.util.*;
import java.text.*;
import java.math.*;
import javax.swing.*;
import java.lang.reflect.*;
import java.net.URL;

public class GraphDisplay {
    
    /*--------------------------------------------------------
     Member Data
     -------------------------------------------------------*/
	/* The graph to display */
	Graph g;
	
	/* The BufferedPanel for the display */
	BufferedPanel window;
	
    /*--------------------------------------------------------
     Constructor
     -------------------------------------------------------*/
	public GraphDisplay(Graph _g, BufferedPanel _window){
		this.g      = _g;
		this.window = _window;;
	};
	
    /*--------------------------------------------------------
     Methods
     -------------------------------------------------------*/
	/* display the node in the graphics window */
	public void showNode(ILocatable n){
	
        if (window == null)
            return;
            
        // get graphics context and set the color
        Graphics2D G = window.getBufferGraphics();
        G.setPaint(Color.red);
        
        Point loc = n.getLocation();
        
        // paint the node
        Ellipse2D.Double E = 
            new Ellipse2D.Double(loc.x - 1, loc.y - 1, 2, 2);
        G.fill(E);
        window.repaint();
	}
	
	/* display the edge in the graphics window */
	public void showEdge(Edge e){

        if (window == null)
            return;
            
        // get graphics context and set the color
        Graphics2D G = window.getBufferGraphics();
        G.setPaint(Color.red);
        
		Point p1 = ((ILocatable)e.start).getLocation();
		Point p2 = ((ILocatable)e.finish).getLocation();
		
        // paint the line
        Line2D.Double L =
            new Line2D.Double(p1.x, p1.y, p2.x, p2.y);
            
        G.draw(L);	
        window.repaint();
	}
	
	/* display all nodes for this graph in the window */
	public void showNodes(){
	
	}
	
	/* display the node's neighbors in the graphics window */
	public void showNeighbors(Node n){
		
		AnEdgeList list = n.edges;
		for (IRange it = new ListRange(list); 
			 it.hasMore(); 
			 it.next()){
		
			showEdge((Edge)it.current());	 
		}
	}
	
	/* display the graph in the graphics window */
	public void showGraph(){

		ArrayList alist = new ArrayList(this.g.nodes.values());
		Iterator it = alist.iterator();
				
		while (it.hasNext()){
			Node n = (Node)it.next();
			
			showNeighbors(n);
			
			System.out.println("\nReady to show node: " + n.toString());
			showNode((ILocatable)n);
		}
	}
	
	
    /*--------------------------------------------------------
     Method to print member data as String
     -------------------------------------------------------*/
	public String toString(){
		return ("" + this.getClass().getName() +
				this.g + ")");
	}

}