/* @(#)Graph.java  16 May 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.codec.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.jpf.*;
import edu.neu.ccs.parser.*;
import edu.neu.ccs.pedagogy.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.util.*;
import java.text.*;
import java.math.*;
import javax.swing.*;
import java.lang.reflect.*;
import java.net.URL;

public class Graph {
    
    /*--------------------------------------------------------
     Member Data
     -------------------------------------------------------*/
	/* The nodes in this graph - with lists of the edges */
	HashMap nodes;
	
    /*--------------------------------------------------------
     Constructor
     -------------------------------------------------------*/
	public Graph(){
		nodes = new HashMap();
	};
	
    /*--------------------------------------------------------
     Methods
     -------------------------------------------------------*/
	/* add a node to the graph */
	public void addNode(Node n){
		if (n != null)
			nodes.put(n.data, n);
	}
	
	/* add an edge to a graph */
	public void addEdge(Edge e){
		
		/* make sure the start and end nodes are in the graph */
		Node n1 = (Node)nodes.get(e.start);
		Node n2 = (Node)nodes.get(e.finish);
		
		if ((n1 != null) && (n2 != null)){
		
			/* add edge in both directions */
			n1.addEdge(e);
			n2.addEdge(new Edge(e.finish, e.start, e.weight));
		}	
	}
	
	/* print all nodes in the graph */
	public String printNodes(){
		if (nodes != null){
			String s = "(";
			ArrayList alist = new ArrayList(nodes.values());
			
			Object[] sarray = alist.toArray();
			for (int i = 0; i < sarray.length; i++){
				s = new String(s + ", " + sarray[i]);
			}
			return s + ")";
		}
		return "null";
	}
	
	
    /*--------------------------------------------------------
     Method to print member data as String
     -------------------------------------------------------*/
	public String toString(){
		return ("new (" + this.getClass().getName() + 
				this.printNodes() + ")");
	}

}