/* @(#)Data.java  16 May 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.codec.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.jpf.*;
import edu.neu.ccs.parser.*;
import edu.neu.ccs.pedagogy.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.util.*;
import java.text.*;
import java.math.*;
import javax.swing.*;
import java.lang.reflect.*;
import java.net.URL;

public class Data implements ILocatable{
    
    /*--------------------------------------------------------
     Member Data
     -------------------------------------------------------*/
	/* The label */
	String name;
	
	/* The location */
	Point location;
	
    /*--------------------------------------------------------
     Constructor
     -------------------------------------------------------*/
	public Data(String _label, Point _point){
		
		this.name = _label;
		this.location = _point;
	};
	
	public Data(String _label, int x, int y){
		
		this(_label, new Point(x, y));
	};
	
    /*--------------------------------------------------------
     Methods
     -------------------------------------------------------*/
	public Point getLocation(){
		return location;
	}
	
	public String getLabel(){
		return name;
	}
    /*--------------------------------------------------------
     Method to print member data as String
     -------------------------------------------------------*/
	public String toString(){
		return ("new (" + this.getClass().getName() + "(" +
				this.name + ": [" +
				this.location.x + "," + 
				this.location.y + "])");
	}

}