/* TreeTestSuite.java  7 May 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.awt.*;
import java.math.*;
import java.util.*;

public class TreeTestSuite extends JPFalt {
    public static void main(String[] args) { new TreeTestSuite(); }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////
    /*----------------------------------------------------------------------- 
     * Test city constructors and the binary search tree
     *----------------------------------------------------------------------- */
    void TestCity(){
	
        City nyc = new City(10027, "NYC", "NY", 73.123456, 40345678);
        println(nyc);
        
        City boston = new City(02115, "Boston", "MA", 71.092215, 42.342706);
        println(boston);
        
        City houston = new City(87654, "Houston", "TX", 82.092215, 39.342706);
        println(boston);
        
        City bos = new City(boston);
        println(boston);
        
        println("Testing zip code converter");
        expected(12345);
        actual(boston.decimal("12345"));
        
        expected(2145);
        actual(boston.decimal("02145"));
        
        Comparator zc = new ZipComparator();
        
        BST t = new BST(zc);
        
        t.insert(boston);
        t.insert(nyc);
        t.insert(bos);
        
        println(t);
        
        expected(true);
        actual(t.find(boston));
        
        expected(true);
        actual(t.find(nyc));
        
        expected(false);
        actual(t.find(houston));
        
        
    }
    
}

