/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern:
   iterator for a list of cities 
*/

class ListRange implements IRange {

    /*-------------------------------------------------------- 
      Member data
      *------------------------------------------------------*/
    AList ptr; /* reference to this list */
    
    /*-------------------------------------------------------- 
      Constructor
      *------------------------------------------------------*/
    ListRange(AList aList) { this.ptr = aList; }
        
    /*--------------------------------------------------------
      Methods to implement the IRange interface
      *------------------------------------------------------*/

    public void next() {
        this.ptr = ((ConsList)this.ptr).rest; 
    }


    public Object current() {
        return ((ConsList)this.ptr).first; 
    }
    
    public boolean hasMore() {
        return (this.ptr instanceof ConsList); 
    }
}
