/*
 * @(#)BST.java  7 May 2003
 */

/**
 * Binary Search Tree
 */
import java.util.*;

public class BST {

	TreeNode root;
	Comparator c;
	
	/* the principal constructor */
	public BST(Comparator aComp){
		root = null;
		c = aComp;
	}
	
	/** determine whether the tree is empty */
    public boolean empty(){
    	return (this.root == null);
    }
    
    /** insert a given object into the tree */
    public void insert(Object obj){    
    		root = insertNode(obj, root);
    }
    
    public TreeNode insertNode(Object obj, TreeNode aRoot){
    
    	if (aRoot == null)
    		return new TreeNode(obj, null, null);
    		
    	else if (c.compare(aRoot.data, obj) < 0){
    		aRoot.left = insertNode(obj, aRoot.left);
    		return aRoot;
    	}    		
    	else{
    		aRoot.right = insertNode(obj, aRoot.right); 
    		return aRoot;
    	}
    }
    
    public boolean find(Object obj){
    	return findNode(obj, root);
    }
    
    public boolean findNode(Object obj, TreeNode aRoot){
    
    	if (aRoot == null)
    		return false;
    		
    	if (c.compare(aRoot.data, obj) == 0)
    		return true;
    		
    	if (c.compare(aRoot.data, obj) < 0)
    		return findNode(obj, aRoot.left );
    		
    	else
    		return findNode(obj, aRoot.right);
    
    }
    
    public boolean remove(Object obj){
    	return true;
    }

    public String toString(){
    	return("" + getClass().getName() + "(" +
    	       this.root + ")\n");
    }

}
