/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import edu.neu.ccs.util.JPTUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundUtilities {
    private static Vector currentLines = new Vector();
    private static float gain = 1.0f;
    private static boolean muted = false;
    private static float pan = 0.0f;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public static void setGain(float f) {
        gain = f;
        Line[] lineArray = currentLines.toArray(new Line[0]);
        int n = 0;
        while (n < lineArray.length) {
            SoundUtilities.applyGain(gain, lineArray[n]);
            ++n;
        }
    }

    public static float getGain() {
        return gain;
    }

    public static void setMuted(boolean bl) {
        if (bl == muted) {
            return;
        }
        muted = bl;
        SoundUtilities.setGain(gain);
    }

    public static boolean isMuted() {
        return muted;
    }

    public static void setPan(float f) {
        pan = f;
        Line[] lineArray = currentLines.toArray(new Line[0]);
        int n = 0;
        while (n < lineArray.length) {
            SoundUtilities.applyPan(pan, lineArray[n]);
            ++n;
        }
    }

    public static float getPan() {
        return pan;
    }

    public static SourceDataLine playSound(String string) {
        return SoundUtilities.playSound(new File(string));
    }

    public static SourceDataLine playSound(File file) {
        try {
            return SoundUtilities.playImpl(AudioSystem.getAudioInputStream(file));
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
        }
        return null;
    }

    public static SourceDataLine playSound(URL uRL) {
        try {
            return SoundUtilities.playImpl(AudioSystem.getAudioInputStream(uRL));
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
        }
        return null;
    }

    public static Thread playMidi(String string) {
        try {
            return SoundUtilities.playImpl(MidiSystem.getSequence(new File(string)));
        }
        catch (IOException iOException) {
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
        }
        return null;
    }

    public static Thread playMidi(File file) {
        try {
            return SoundUtilities.playImpl(MidiSystem.getSequence(file));
        }
        catch (IOException iOException) {
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
        }
        return null;
    }

    public static Thread playMidi(URL uRL) {
        try {
            SoundUtilities.playImpl(MidiSystem.getSequence(uRL));
        }
        catch (IOException iOException) {
        }
        catch (InvalidMidiDataException invalidMidiDataException) {}
        return null;
    }

    private static SourceDataLine playImpl(final AudioInputStream audioInputStream) {
        SourceDataLine sourceDataLine;
        AudioFormat audioFormat;
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = SoundUtilities.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat = audioInputStream.getFormat());
        if (!AudioSystem.isLineSupported(info)) {
            return null;
        }
        try {
            sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            sourceDataLine.open(audioFormat, 16384);
        }
        catch (LineUnavailableException lineUnavailableException) {
            return null;
        }
        SoundUtilities.applyGain(gain, sourceDataLine);
        SoundUtilities.applyPan(pan, sourceDataLine);
        currentLines.add(sourceDataLine);
        Thread thread = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    int n = sourceDataLine.getBufferSize() / 8 * audioFormat.getFrameSize();
                    byte[] byArray = new byte[n];
                    block2: while (true) {
                        int n2;
                        if ((n2 = audioInputStream.read(byArray)) == -1) {
                            sourceDataLine.stop();
                            sourceDataLine.close();
                            break;
                        }
                        while (true) {
                            if (n2 <= 0) continue block2;
                            n2 -= sourceDataLine.write(byArray, 0, n2);
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SoundUtilities.removeLine(sourceDataLine);
            }
        };
        sourceDataLine.start();
        thread.start();
        return sourceDataLine;
    }

    private static Thread playImpl(Sequence sequence) {
        Sequencer sequencer;
        try {
            sequencer = MidiSystem.getSequencer();
            if (!sequencer.isOpen()) {
                sequencer.open();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            return null;
        }
        try {
            sequencer.setSequence(sequence);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return null;
        }
        Thread thread = new Thread(){

            public void run() {
                sequencer.start();
                while (sequencer.isRunning()) {
                    JPTUtilities.pauseThread(50L);
                }
                sequencer.stop();
            }
        };
        thread.start();
        return thread;
    }

    private static void removeLine(Line line) {
        currentLines.remove(line);
    }

    private static void applyGain(float f, Line line) {
        try {
            if (muted) {
                f = -3.4028235E38f;
            }
            FloatControl floatControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
            f = Math.max(f, floatControl.getMinimum());
            f = Math.min(f, floatControl.getMaximum());
            floatControl.setValue(f);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private static void applyPan(float f, Line line) {
        try {
            FloatControl floatControl = (FloatControl)line.getControl(FloatControl.Type.PAN);
            f = Math.max(f, floatControl.getMinimum());
            f = Math.min(f, floatControl.getMaximum());
            floatControl.setValue(f);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

