/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ZooContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import javax.swing.JComponent;

public class ZooGroup
extends ZooContainer {
    protected Dimension oldSize = null;
    protected AffineTransform transform = new AffineTransform();

    public ZooGroup(Vector vector) {
        this.setOpaque(false);
        Component[] componentArray = vector.toArray(new Component[0]);
        Rectangle rectangle = this.getBoundingBox(componentArray);
        if (rectangle != null) {
            super.setBounds(rectangle);
        }
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setLocation(componentArray[n].getX() - this.getX(), componentArray[n].getY() - this.getY());
            this.add(componentArray[n]);
            ++n;
        }
    }

    public void setLocation(int n, int n2) {
        this.setBoundsImpl(n, n2, this.getWidth(), this.getHeight());
    }

    public void setLocation(Point point) {
        this.setBoundsImpl(point.x, point.y, this.getWidth(), this.getHeight());
    }

    public void setSize(int n, int n2) {
        this.setBoundsImpl(this.getX(), this.getY(), n, n2);
    }

    public void setSize(Dimension dimension) {
        this.setBoundsImpl(this.getX(), this.getY(), dimension.width, dimension.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setBoundsImpl(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBoundsImpl(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void addNotify() {
        super.addNotify();
        this.updateBoundsRestrictions();
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        this.paintBorder(graphics);
        this.paintComponent(graphics);
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.concatenate(new AffineTransform(this.transform));
        graphics2D.setTransform(affineTransform2);
        this.paintChildren(graphics);
        graphics2D.setTransform(affineTransform);
    }

    protected Dimension calculateMinimumSize() {
        Component component = this.getComponent(0);
        Dimension dimension = component.getMinimumSize();
        double d = 0.0;
        double d2 = 0.0;
        d = component.getWidth() == 0 ? Double.MAX_VALUE : (double)dimension.width / (double)component.getWidth();
        d2 = component.getHeight() == 0 ? Double.MAX_VALUE : (double)dimension.height / (double)component.getHeight();
        int n = 1;
        while (n < this.getComponentCount()) {
            component = this.getComponent(n);
            dimension = component.getMinimumSize();
            d = component.getWidth() == 0 ? Double.MAX_VALUE : Math.max((double)dimension.width / (double)component.getWidth(), d);
            d2 = component.getHeight() == 0 ? Double.MAX_VALUE : Math.max((double)dimension.height / (double)component.getHeight(), d2);
            ++n;
        }
        double d3 = d * (double)this.getWidth();
        double d4 = d2 * (double)this.getHeight();
        return new Dimension(d3 > 2.147483647E9 ? Integer.MAX_VALUE : (int)(d3 + 1.0), d4 > 2.147483647E9 ? Integer.MAX_VALUE : (int)(d4 + 1.0));
    }

    protected Dimension calculateMaximumSize() {
        Component component = this.getComponent(0);
        Dimension dimension = component.getMaximumSize();
        double d = 0.0;
        double d2 = 0.0;
        d = component.getWidth() == 0 ? Double.MAX_VALUE : (double)dimension.width / (double)component.getWidth();
        d2 = component.getHeight() == 0 ? Double.MAX_VALUE : (double)dimension.height / (double)component.getHeight();
        int n = 1;
        while (n < this.getComponentCount()) {
            component = this.getComponent(n);
            dimension = component.getMaximumSize();
            d = component.getWidth() == 0 ? d : Math.min((double)dimension.width / (double)component.getWidth(), d);
            d2 = component.getHeight() == 0 ? d2 : Math.min((double)dimension.height / (double)component.getHeight(), d2);
            ++n;
        }
        double d3 = d * (double)this.getWidth();
        double d4 = d2 * (double)this.getHeight();
        return new Dimension(d3 > 2.147483647E9 ? Integer.MAX_VALUE : (int)d3, d4 > 2.147483647E9 ? Integer.MAX_VALUE : (int)d4);
    }

    void startResize() {
        this.oldSize = this.getSize();
    }

    void endResize() {
        this.transform = new AffineTransform();
        Rectangle rectangle = this.getBounds();
        double d = (double)rectangle.width / (double)this.oldSize.width;
        double d2 = (double)rectangle.height / (double)this.oldSize.height;
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            rectangle = componentArray[n].getBounds();
            componentArray[n].setBounds((int)((double)rectangle.x * d + 0.5), (int)((double)rectangle.y * d2 + 0.5), (int)((double)rectangle.width * d + 0.5), (int)((double)rectangle.height * d2 + 0.5));
            this.revalidate(componentArray[n]);
            ++n;
        }
        this.oldSize = null;
        this.updateBoundsRestrictions();
    }

    private void updateBoundsRestrictions() {
        if (this.getComponentCount() > 0) {
            this.setMinimumSize(this.calculateMinimumSize());
            this.setMaximumSize(this.calculateMaximumSize());
        }
    }

    private void setBoundsImpl(int n, int n2, int n3, int n4) {
        if (this.oldSize != null) {
            this.transform = AffineTransform.getScaleInstance((double)n3 / (double)this.oldSize.width, (double)n4 / (double)this.oldSize.height);
        } else {
            Rectangle rectangle = this.getBounds();
            double d = (double)n3 / (double)rectangle.width;
            double d2 = (double)n4 / (double)rectangle.height;
            Component[] componentArray = this.getComponents();
            int n5 = 0;
            while (n5 < componentArray.length) {
                rectangle = componentArray[n5].getBounds();
                componentArray[n5].setBounds((int)((double)rectangle.x * d + 0.5), (int)((double)rectangle.y * d2 + 0.5), (int)((double)rectangle.width * d + 0.5), (int)((double)rectangle.height * d2 + 0.5));
                this.revalidate(componentArray[n5]);
                ++n5;
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    private Rectangle getBoundingBox(Component[] componentArray) {
        if (componentArray == null || componentArray.length == 0) {
            return null;
        }
        Rectangle rectangle = new Rectangle(componentArray[0].getBounds());
        int n = 1;
        while (n < componentArray.length) {
            rectangle = rectangle.union(componentArray[n].getBounds());
            ++n;
        }
        return rectangle;
    }

    private void revalidate(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.revalidate();
            return;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            container.validate();
            return;
        }
    }
}

