/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XInt;
import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.WindowActionAdapter;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;

public class JPTFrame
extends JFrame
implements JPTConstants {
    public static final int EXIT_ON_CLOSE = 3;
    public static final int EXIT_ON_CLOSE_IF_LAST = 6;
    public static final int DEFAULT_CLOSE_OPERATION = 6;
    protected static XInt counter = new XInt(0);
    protected int closeOperation = 6;

    public JPTFrame() {
        this("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPTFrame(String string) {
        super(string);
        super.setDefaultCloseOperation(0);
        this.setDefaultCloseOperation(6);
        this.installWindowAdapter();
        XInt xInt = counter;
        synchronized (xInt) {
            counter.setValue(counter.getValue() + 1);
        }
    }

    public void center() {
        this.setLocation(0);
    }

    public void setLocation(int n) {
        this.setLocation(n, new Insets(0, 0, 0, 0));
    }

    public void setLocation(int n, Insets insets) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = new Point();
        int n2 = dimension.width - insets.left - insets.right - this.getWidth();
        int n3 = dimension.height - insets.top - insets.bottom - this.getHeight();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        int n4 = insets.left;
        int n5 = insets.left + n2 / 2;
        int n6 = insets.left + n2;
        int n7 = insets.top + 0;
        int n8 = insets.top + n3 / 2;
        int n9 = insets.top + n3;
        switch (n) {
            case 2: {
                point.setLocation(n6, n7);
                break;
            }
            case 3: {
                point.setLocation(n6, n8);
                break;
            }
            case 4: {
                point.setLocation(n6, n9);
                break;
            }
            case 1: {
                point.setLocation(n5, n7);
                break;
            }
            case -1: 
            case 0: {
                point.setLocation(n5, n8);
                break;
            }
            case 5: {
                point.setLocation(n5, n9);
                break;
            }
            case 8: {
                point.setLocation(n4, n7);
                break;
            }
            case 7: {
                point.setLocation(n4, n8);
                break;
            }
            case 6: {
                point.setLocation(n4, n9);
                break;
            }
            default: {
                return;
            }
        }
        this.setLocation(point.x, point.y);
    }

    public void addNotify() {
        super.addNotify();
        this.setSize(this.getSize().width + this.getInsets().left + this.getInsets().right, this.getSize().height + this.getInsets().top + this.getInsets().bottom);
    }

    public void setDefaultCloseOperation(int n) {
        switch (n) {
            case -1: {
                this.closeOperation = 6;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                this.closeOperation = n;
                break;
            }
            default: {
                return;
            }
        }
    }

    public int getDefaultCloseOperation() {
        return this.closeOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getJPTFrameCount() {
        XInt xInt = counter;
        synchronized (xInt) {
            return counter.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        XInt xInt = counter;
        synchronized (xInt) {
            counter.setValue(counter.getValue() - 1);
            super.dispose();
        }
    }

    public static JPTFrame createQuickJPTFrame(String string, Component component) {
        return JPTFrame.createQuickJPTFrame(string, component, new CenterLayout());
    }

    public static JPTFrame createQuickJPTFrame(String string, Component component, LayoutManager layoutManager) {
        return JPTFrame.createQuickJPTFrame(string, component, layoutManager, -1);
    }

    public static JPTFrame createQuickJPTFrame(String string, Component component, int n) {
        return JPTFrame.createQuickJPTFrame(string, component, new CenterLayout(), n);
    }

    public static JPTFrame createQuickJPTFrame(String string, Component component, LayoutManager layoutManager, int n) {
        JPTFrame jPTFrame = new JPTFrame(string == null ? "" : string);
        if (layoutManager != null) {
            jPTFrame.getContentPane().setLayout(layoutManager);
        }
        if (component != null) {
            jPTFrame.getContentPane().add(component);
        }
        jPTFrame.pack();
        jPTFrame.setLocation(n);
        jPTFrame.setVisible(true);
        return jPTFrame;
    }

    protected static XInt getCounter() {
        return counter;
    }

    public void installWindowAdapter() {
        WindowActionAdapter windowActionAdapter = new WindowActionAdapter(this);
        windowActionAdapter.addWindowClosingAction(new SimpleAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform() {
                XInt xInt = JPTFrame.getCounter();
                synchronized (xInt) {
                    int n = JPTFrame.this.getDefaultCloseOperation();
                    if (n == 0) {
                        return;
                    }
                    JPTFrame.this.setVisible(false);
                    if (n == 1) {
                        return;
                    }
                    JPTFrame.this.dispose();
                    if (n == 2) {
                        return;
                    }
                    if (n == 3 || JPTFrame.getJPTFrameCount() == 0) {
                        System.exit(0);
                    }
                }
            }
        });
    }
}

