/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.gui.ActionWrapper;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.SimpleAction;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;

public class DialogAction
extends ActionWrapper
implements ConsoleAware {
    public static final Object KEEP_OPEN = new Object();
    public static final Object AUTO_CLOSE = new Object();
    public static final Object SET_CANCEL = new Object();
    protected GeneralDialog dialog = null;
    protected Object finish = AUTO_CLOSE;

    public DialogAction(GeneralDialog generalDialog, Action action, Object object) {
        if (generalDialog == null) {
            throw new NullPointerException("Null dialog passed to a DialogAction constructor");
        }
        this.dialog = generalDialog;
        this.setAction(action);
        this.setFinish(object);
    }

    public DialogAction(GeneralDialog generalDialog, String string, Object object) {
        this(generalDialog, DialogAction.makeTrivialAction(string), object);
    }

    public DialogAction(GeneralDialog generalDialog, String string, Icon icon, Object object) {
        this(generalDialog, DialogAction.makeTrivialAction(string, icon), object);
    }

    public DialogAction(GeneralDialog generalDialog, Object[] objectArray) {
        if (generalDialog == null) {
            throw new NullPointerException("Null dialog passed to a DialogAction constructor");
        }
        this.dialog = generalDialog;
        this.setActionAndFinish(objectArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.dialog.setCancelled(false);
        String string = this.getName();
        try {
            if (this.action != null) {
                this.action.actionPerformed(actionEvent);
            }
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            string2 = "\nDialogAction Error: " + string2 + "\nIn Action: " + string;
            ConsoleAware.console.err.println();
            ConsoleAware.console.err.println(string2);
            ConsoleAware.console.err.println();
            exception.printStackTrace(ConsoleAware.console.err);
            ConsoleAware.console.err.println();
            if (this.finish == KEEP_OPEN) {
                this.finish = AUTO_CLOSE;
            }
            throw new RuntimeException(string2);
        }
        finally {
            if (this.finish == KEEP_OPEN) {
                return;
            }
            if (this.finish == SET_CANCEL) {
                this.dialog.setCancelled(true);
            }
            this.dialog.setResponseAndClose(string);
        }
    }

    public Object getFinish() {
        return this.finish;
    }

    public void setFinish(Object object) {
        this.finish = object == KEEP_OPEN || object == AUTO_CLOSE || object == SET_CANCEL ? object : AUTO_CLOSE;
    }

    public void setActionAndFinish(Object[] objectArray) {
        Action action = null;
        String string = null;
        Icon icon = null;
        Object object = AUTO_CLOSE;
        if (objectArray != null) {
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (objectArray[n2] instanceof Action) {
                    action = (Action)objectArray[n2];
                    ++n2;
                    continue;
                }
                if (objectArray[n2] instanceof String) {
                    string = (String)objectArray[n2];
                    if (++n2 < n && objectArray[n2] instanceof Icon) {
                        icon = (Icon)objectArray[n2];
                        ++n2;
                        action = DialogAction.makeTrivialAction(string, icon);
                        continue;
                    }
                    action = DialogAction.makeTrivialAction(string);
                    continue;
                }
                if (objectArray[n2] == KEEP_OPEN) {
                    object = KEEP_OPEN;
                    break;
                }
                if (objectArray[n2] == AUTO_CLOSE) {
                    object = AUTO_CLOSE;
                    break;
                }
                if (objectArray[n2] != SET_CANCEL) break;
                object = SET_CANCEL;
                break;
            }
        }
        this.setAction(action);
        this.setFinish(object);
    }

    public static DialogAction makeDialogAction(GeneralDialog generalDialog, Object[] objectArray) {
        if (generalDialog == null) {
            throw new NullPointerException("Null dialog passed to makeDialogAction");
        }
        return new DialogAction(generalDialog, objectArray);
    }

    public static DialogAction[] makeDialogActions(GeneralDialog generalDialog, Object[][] objectArray) {
        if (generalDialog == null) {
            throw new NullPointerException("Null dialog passed to makeDialogActions");
        }
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        DialogAction[] dialogActionArray = new DialogAction[n];
        int n2 = 0;
        while (n2 < n) {
            dialogActionArray[n2] = DialogAction.makeDialogAction(generalDialog, objectArray[n2]);
            ++n2;
        }
        return dialogActionArray;
    }

    public static Action makeTrivialAction(String string) {
        return new SimpleAction(string){

            public void perform() {
            }
        };
    }

    public static Action makeTrivialAction(String string, Icon icon) {
        return new SimpleAction(string, icon){

            public void perform() {
            }
        };
    }
}

