/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AlertEvent;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.util.JPTUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class Annotation
extends DisplayPanel {
    public static final String ALERT_ICON = "alert.icon";
    public static final int DEFAULT_ALIGNMENT = 1;
    protected Color oldForeground = null;
    protected Color oldBackground = null;
    protected JLabel iconLabel = new JLabel();
    protected JTextArea textLabel = new JTextArea(){

        public boolean isFocusTraversable() {
            return this.isEditable();
        }

        public void requestFocus() {
            if (!this.isEditable()) {
                this.transferFocus();
            }
        }
    };
    protected int align = 1;
    protected Icon alertIcon = null;

    public Annotation() {
        this(null, null, 1);
    }

    public Annotation(String string) {
        this(string, null, 1);
    }

    public Annotation(Icon icon) {
        this(null, icon, 1);
    }

    public Annotation(String string, Icon icon, int n) {
        this.setAlignment(n);
        this.textLabel.setFont(this.iconLabel.getFont());
        this.textLabel.setForeground(this.iconLabel.getForeground());
        this.textLabel.setBackground(this.iconLabel.getBackground());
        this.textLabel.setLineWrap(false);
        this.textLabel.setEditable(false);
        this.setText(string);
        this.setIcon(icon);
    }

    public void dataMalformed(MalformedDataEvent malformedDataEvent) {
        if (malformedDataEvent.isAlertOn()) {
            this.startAlert(malformedDataEvent);
        } else {
            this.endAlert(malformedDataEvent);
        }
    }

    public void startAlert(AlertEvent alertEvent) {
        this.oldForeground = this.textLabel.getForeground();
        this.oldBackground = this.getBackground();
        this.setForeground(SystemColor.textHighlightText);
        this.setBackground(SystemColor.textHighlight);
        if (this.alertIcon != null) {
            this.iconLabel.setIcon(this.alertIcon);
        }
    }

    public void endAlert(AlertEvent alertEvent) {
        this.setForeground(this.oldForeground);
        this.setBackground(this.oldBackground);
        this.setEnabled(this.isEnabled());
    }

    public void setAlignment(int n) {
        int n2 = this.getAlignment();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.align = n;
                break;
            }
            case -1: {
                this.align = 1;
                break;
            }
            default: {
                return;
            }
        }
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.textLabel, "Center");
        this.add((Component)this.iconLabel, JPTUtilities.getBorderLayoutLocation(this.align));
        this.revalidate();
        if (this.getAlignment() != n2) {
            this.firePropertyChange("alignment", n2, this.getAlignment());
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setForeground(Color color) {
        if (color == null) {
            return;
        }
        if (this.iconLabel != null) {
            this.iconLabel.setForeground(color);
        }
        if (this.textLabel != null) {
            this.textLabel.setForeground(color);
        }
        super.setForeground(color);
    }

    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        if (this.iconLabel != null) {
            this.iconLabel.setBackground(color);
        }
        if (this.textLabel != null) {
            this.textLabel.setBackground(color);
        }
        super.setBackground(color);
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        if (this.iconLabel != null) {
            this.iconLabel.setFont(font);
        }
        if (this.textLabel != null) {
            this.textLabel.setFont(font);
        }
        super.setFont(font);
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (this.textLabel != null) {
            this.textLabel.setText(string);
        }
    }

    public String getText() {
        if (this.textLabel != null) {
            return this.textLabel.getText();
        }
        return null;
    }

    public void setIcon(Icon icon) {
        if (this.iconLabel != null) {
            this.iconLabel.setIcon(icon);
        }
    }

    public Icon getIcon() {
        if (this.iconLabel != null) {
            return this.iconLabel.getIcon();
        }
        return null;
    }

    public void setDisabledIcon(Icon icon) {
        if (this.iconLabel != null) {
            this.iconLabel.setDisabledIcon(icon);
        }
    }

    public Icon getDisabledIcon() {
        if (this.iconLabel != null) {
            return this.iconLabel.getDisabledIcon();
        }
        return null;
    }

    public void setAlertIcon(Icon icon) {
        Icon icon2 = this.getAlertIcon();
        this.alertIcon = icon;
        if (this.getAlertIcon() != icon2) {
            this.firePropertyChange(ALERT_ICON, icon2, this.getAlertIcon());
        }
    }

    public Icon getAlertIcon() {
        return this.alertIcon;
    }
}

