/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.filter;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XString;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import java.io.Serializable;

public class CaseActionFilter
implements StringableFilter,
Cloneable,
Serializable {
    public static final CaseActionFilter UPPER_CASE = new CaseActionFilter(){

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            super.filterStringable(stringable);
            XString xString = (XString)stringable;
            String string = xString.getValue();
            xString.setValue(string.toUpperCase());
            return xString;
        }
    };
    public static final CaseActionFilter LOWER_CASE = new CaseActionFilter(){

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            super.filterStringable(stringable);
            XString xString = (XString)stringable;
            String string = xString.getValue();
            xString.setValue(string.toLowerCase());
            return xString;
        }
    };
    public static final CaseActionFilter TITLE_CASE = new CaseActionFilter(){

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            super.filterStringable(stringable);
            XString xString = (XString)stringable;
            StringBuffer stringBuffer = new StringBuffer(xString.getValue());
            boolean bl = true;
            int n = 0;
            while (n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                if (Character.isLetter(c)) {
                    stringBuffer.setCharAt(n, bl ? Character.toUpperCase(c) : Character.toLowerCase(c));
                    bl = false;
                } else if (Character.isWhitespace(c)) {
                    bl = true;
                }
                ++n;
            }
            xString.setValue(stringBuffer.toString());
            return xString;
        }
    };

    public Stringable filterStringable(Stringable stringable) throws FilterException {
        if (stringable instanceof XString) {
            return stringable;
        }
        throw new FilterException(stringable, "Not a string: " + stringable.toString());
    }
}

