/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.console;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.console.ConsoleTextPane;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.util.FileExistsException;
import edu.neu.ccs.util.FileUtilities;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

final class ConsoleWindow
extends JPTFrame
implements ConsoleAware,
JPTConstants,
Serializable {
    public static final int OUT = 0;
    public static final int ERR = 1;
    public static final int IN = 2;
    private Hashtable actions = null;
    private Action save = null;
    private Action transcript = null;
    private transient FileOutputStream scriptStream = null;
    private File scriptFile = null;
    private JScrollPane scroll = null;
    private ConsoleTextPane tablet = null;
    private Object inputmode_mutex = new Object();

    public ConsoleWindow() {
        super("Text console");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConsoleWindow.this.close();
            }
        });
        this.tablet = new ConsoleTextPane(this);
        this.actions = this.createActionsTable();
        this.setJMenuBar(this.createMenuBar());
        this.save.setEnabled(false);
        this.scroll = new JScrollPane(this.tablet);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.setContentPane(this.scroll);
        this.setSize(640, 480);
        this.setResizable(false);
        this.setFontSize(14);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.scriptStream = new FileOutputStream(this.scriptFile);
        }
        catch (Exception exception) {
            this.scriptFile = null;
            this.scriptStream = null;
            this.transcript.putValue("Name", "Start transcript");
        }
    }

    public void consoleInputPerformed(String string) {
        this.save.setEnabled(true);
        this.fireConsoleInputPerformed(string);
    }

    public void consoleOutputPerformed(String string, int n) {
        block2: {
            this.save.setEnabled(true);
            this.tablet.append(string, n);
            if (this.scriptStream == null) break block2;
            try {
                this.scriptStream.write(string.getBytes());
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "There was an error writing to the transcript file.", "Warning!", 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputMode(boolean bl) {
        Object object = this.inputmode_mutex;
        synchronized (object) {
            if (bl) {
                this.tablet.setStream(2);
            } else {
                this.tablet.setStream(0);
            }
        }
    }

    public void setInputColor(Color color) {
        this.tablet.setInputColor(color);
    }

    public Color getInputColor() {
        return this.tablet.getInputColor();
    }

    public void setOutputColor(Color color) {
        this.tablet.setOutputColor(color);
    }

    public Color getOutputColor() {
        return this.tablet.getOutputColor();
    }

    public void setErrorColor(Color color) {
        this.tablet.setErrorColor(color);
    }

    public Color getErrorColor() {
        return this.tablet.getErrorColor();
    }

    public void setFontSize(int n) {
        n = n < 4 ? 4 : n;
        n = n > 72 ? 72 : n;
        this.tablet.setFontSize(n);
    }

    public void close() {
        if (this.save.isEnabled() && JOptionPane.showConfirmDialog(this, "Do you want to save a transcript of the console contents?", "Save contents", 0) == 0) {
            this.save();
        }
        ConsoleAware.console.setActivated(false);
        this.setVisible(false);
        this.dispose();
        if (JPTFrame.getJPTFrameCount() == 0) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConsoleInputPerformed(String string) {
        Object object = this.inputmode_mutex;
        synchronized (object) {
            ConsoleAware.console.consoleInputPerformed(string);
        }
    }

    private Hashtable createActionsTable() {
        Hashtable<String, Action> hashtable = new Hashtable<String, Action>();
        Action[] actionArray = this.tablet.getActions();
        int n = 0;
        while (n < actionArray.length) {
            hashtable.put((String)actionArray[n].getValue("Name"), actionArray[n]);
            ++n;
        }
        return hashtable;
    }

    private Action getAction(String string) {
        return (Action)this.actions.get(string);
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        this.save = new SimpleAction("Save contents"){

            public void perform() {
                ConsoleWindow.this.save();
            }
        };
        jMenu.add(this.save);
        this.transcript = new SimpleAction("Start transcript"){

            public void perform() {
                ConsoleWindow.this.transcript();
            }
        };
        jMenu.add(this.transcript);
        jMenu.addSeparator();
        jMenu.add(new SimpleAction("Close window"){

            public void perform() {
                ConsoleWindow.this.close();
            }
        });
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.add(new SimpleAction("Cut"){

            public void perform() {
                ConsoleWindow.this.getTextPane().cut();
            }
        });
        jMenu2.add(new AbstractAction("Copy"){

            public void actionPerformed(ActionEvent actionEvent) {
                Action action = ConsoleWindow.this.getAction("copy-to-clipboard");
                if (action != null) {
                    action.actionPerformed(actionEvent);
                }
            }
        });
        jMenu2.add(new SimpleAction("Paste"){

            public void perform() {
                ConsoleWindow.this.getTextPane().paste();
            }
        });
        jMenu2.addSeparator();
        jMenu2.add(new AbstractAction("Select all"){

            public void actionPerformed(ActionEvent actionEvent) {
                Action action = ConsoleWindow.this.getAction("select-all");
                if (action != null) {
                    action.actionPerformed(actionEvent);
                }
            }
        });
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Font size");
        jMenu3.add(new SimpleAction("10 point"){

            public void perform() {
                ConsoleWindow.this.setFontSize(10);
            }
        });
        jMenu3.add(new SimpleAction("12 point"){

            public void perform() {
                ConsoleWindow.this.setFontSize(12);
            }
        });
        jMenu3.add(new SimpleAction("14 point"){

            public void perform() {
                ConsoleWindow.this.setFontSize(14);
            }
        });
        jMenu3.add(new SimpleAction("16 point"){

            public void perform() {
                ConsoleWindow.this.setFontSize(16);
            }
        });
        jMenu3.add(new SimpleAction("18 point"){

            public void perform() {
                ConsoleWindow.this.setFontSize(18);
            }
        });
        jMenu3.add(new SimpleAction("24 point"){

            public void perform() {
                ConsoleWindow.this.setFontSize(24);
            }
        });
        jMenu3.add(new SimpleAction("36 point"){

            public void perform() {
                ConsoleWindow.this.setFontSize(36);
            }
        });
        jMenuBar.add(jMenu3);
        return jMenuBar;
    }

    private void save() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save contents");
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return true;
            }

            public String getDescription() {
                return "All files (*.*)";
            }
        });
        while (jFileChooser.showSaveDialog(this) == 0) {
            try {
                try {
                    FileUtilities.writeFile(jFileChooser.getSelectedFile(), this.tablet.getText(), false);
                    this.save.setEnabled(false);
                }
                catch (FileExistsException fileExistsException) {
                    int n = JOptionPane.showConfirmDialog(null, "A file with that name already exists.  Do you want to overwrite it?", "Warning!", 1, 2);
                    if (n == 0) {
                        FileUtilities.writeFile(jFileChooser.getSelectedFile(), this.tablet.getText(), true);
                        this.save.setEnabled(false);
                        break;
                    }
                    if (n != 2) continue;
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "The file could not be saved.", "Error!", 0);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transcript() {
        block8: {
            block9: {
                if (this.scriptStream != null) break block9;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Start transcript");
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return true;
                    }

                    public String getDescription() {
                        return "All files (*.*)";
                    }
                });
                while (jFileChooser.showDialog(this, "Select") == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (file.exists() && JOptionPane.showConfirmDialog(null, "A file with that name already exists.  Do you want to overwrite it?", "Warning!", 1, 2) != 0) continue;
                    try {
                        this.scriptFile = jFileChooser.getSelectedFile();
                        this.scriptStream = new FileOutputStream(this.scriptFile);
                        this.transcript.putValue("Name", "Stop transcript");
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, "The transcript could not be opened.", "Error!", 0);
                    }
                    break block8;
                }
                break block8;
            }
            if (JOptionPane.showConfirmDialog(null, "Do you want to close the transcript file?", "Stop transcript", 0) != 0) break block8;
            try {
                this.scriptStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.scriptFile = null;
                this.scriptStream = null;
                this.transcript.putValue("Name", "Start transcript");
            }
        }
    }

    private ConsoleTextPane getTextPane() {
        return this.tablet;
    }
}

