/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.console;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XBigDecimal;
import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XByte;
import edu.neu.ccs.XChar;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XFloat;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XObject;
import edu.neu.ccs.XShort;
import edu.neu.ccs.XString;
import edu.neu.ccs.console.ConsoleInputListener;
import edu.neu.ccs.console.ConsoleWindow;
import edu.neu.ccs.filter.CaseActionFilter;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.StringableFactory;
import edu.neu.ccs.util.SystemUtilities;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import javax.swing.event.SwingPropertyChangeSupport;

public class ConsoleGateway
implements ConsoleInputListener,
JPTConstants,
Serializable {
    private static final int OUT = 0;
    private static final int ERR = 1;
    private static final int IN = 2;
    public static final String ACTIVATED = "activated";
    public static final String INPUT_COLOR = "input.color";
    public static final String OUTPUT_COLOR = "output.color";
    public static final String ERROR_COLOR = "error.color";
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);
    protected CaseActionFilter action = null;
    protected String input = "";
    protected transient InputStream inStream = null;
    protected transient OutputStream[] outStreams = null;
    protected transient String endl = null;
    protected ConsoleWindow window = null;
    public ConsoleInputStream in = new ConsoleInputStream();
    public PrintStream out = new PrintStream(new ConsoleOutputStream(0));
    public PrintStream err = new PrintStream(new ConsoleOutputStream(1));
    static /* synthetic */ Class class$edu$neu$ccs$XInt;
    static /* synthetic */ Class class$edu$neu$ccs$XByte;
    static /* synthetic */ Class class$edu$neu$ccs$XShort;
    static /* synthetic */ Class class$edu$neu$ccs$XLong;
    static /* synthetic */ Class class$edu$neu$ccs$XFloat;
    static /* synthetic */ Class class$edu$neu$ccs$XDouble;
    static /* synthetic */ Class class$edu$neu$ccs$XChar;
    static /* synthetic */ Class class$edu$neu$ccs$XBoolean;
    static /* synthetic */ Class class$edu$neu$ccs$XString;
    static /* synthetic */ Class class$edu$neu$ccs$XBigInteger;
    static /* synthetic */ Class class$edu$neu$ccs$XBigDecimal;

    public ConsoleGateway() {
        this.inStream = System.in;
        this.outStreams = new OutputStream[]{System.out, System.err};
        this.endl = SystemUtilities.getLineSeparator();
    }

    public synchronized void consoleInputPerformed(String string) {
        this.input = string.substring(0, string.indexOf(this.endl));
        this.notify();
    }

    public synchronized void prompt(String string) {
        if (string != null && string.length() > 0) {
            this.out.print(string + " ");
        }
    }

    public synchronized void prompt(String string, String string2) {
        this.prompt(string);
        if (string2 != null && string2.length() > 0) {
            this.out.print("[" + string2 + "] ");
        }
    }

    public synchronized void pressReturn() {
        this.pressReturn(null);
    }

    public synchronized void pressReturn(String string) {
        if (string != null && string.length() > 0) {
            this.out.println(string);
        }
        this.prompt("Press return to continue");
        this.getOneLine();
    }

    public synchronized boolean confirm(String string, boolean bl) {
        String string2 = bl ? "Y" : "N";
        String string3 = "";
        while ((string3 = this.in.demandString(string, string2)).length() != 0) {
            if (Character.toUpperCase(string3.charAt(0)) == 'Y') {
                bl = true;
                break;
            }
            if (Character.toUpperCase(string3.charAt(0)) == 'N') {
                bl = false;
                break;
            }
            this.out.println("Must answer Y[es] or N[o].");
            this.out.println();
        }
        return bl;
    }

    public synchronized void setCaseActionFilter(CaseActionFilter caseActionFilter) {
        this.action = caseActionFilter;
    }

    public synchronized CaseActionFilter getCaseActionFilter() {
        return this.action;
    }

    public synchronized void setActivated(boolean bl) {
        boolean bl2 = this.isActivated();
        if (bl && !this.isActivated()) {
            this.window = new ConsoleWindow();
            this.window.setVisible(true);
        } else if (!bl && this.isActivated()) {
            ConsoleWindow consoleWindow = this.window;
            this.window = null;
            consoleWindow.close();
        }
        if (this.isActivated() != bl2) {
            this.changeAdapter.firePropertyChange(ACTIVATED, bl2, this.isActivated());
        }
    }

    public synchronized boolean isActivated() {
        return this.window != null;
    }

    public synchronized void setInputColor(Color color) {
        if (this.isActivated()) {
            Color color2 = this.getInputColor();
            this.window.setInputColor(color);
            this.changeAdapter.firePropertyChange(INPUT_COLOR, color2, this.getInputColor());
        }
    }

    public synchronized Color getInputColor() {
        if (this.isActivated()) {
            return this.window.getInputColor();
        }
        return null;
    }

    public synchronized void setOutputColor(Color color) {
        if (this.isActivated()) {
            Color color2 = this.getOutputColor();
            this.window.setOutputColor(color);
            this.changeAdapter.firePropertyChange(OUTPUT_COLOR, color2, this.getOutputColor());
        }
    }

    public synchronized Color getOutputColor() {
        if (this.isActivated()) {
            return this.window.getOutputColor();
        }
        return null;
    }

    public synchronized void setErrorColor(Color color) {
        if (this.isActivated()) {
            Color color2 = this.getErrorColor();
            this.window.setErrorColor(color);
            this.changeAdapter.firePropertyChange(ERROR_COLOR, color2, this.getErrorColor());
        }
    }

    public synchronized Color getErrorColor() {
        if (this.isActivated()) {
            return this.window.getErrorColor();
        }
        return null;
    }

    public synchronized void selectBlackTextScheme() {
        this.setOutputColor(Color.black);
        this.setInputColor(Color.black);
        this.setErrorColor(Color.black);
    }

    public synchronized void selectColorTextScheme() {
        this.setOutputColor(Color.black);
        this.setInputColor(Color.blue);
        this.setErrorColor(Color.red);
    }

    public void setFontSize(int n) {
        if (this.isActivated()) {
            this.window.setFontSize(n);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(string, propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized String getOneLine() {
        block16: {
            if (this.isActivated()) {
                this.input = null;
                this.window.setInputMode(true);
                try {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        if (this.input == null) {
                            this.input = "";
                        }
                    }
                    Object var3_1 = null;
                    if (this.input == null) {
                        this.input = "";
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.input == null) {
                        this.input = "";
                    }
                    throw throwable;
                }
                this.window.setInputMode(false);
            } else {
                StringBuffer stringBuffer = new StringBuffer("");
                while (stringBuffer.toString().indexOf(this.endl) < 0) {
                    try {
                        int n = this.inStream.read();
                        if (n < 0) {
                            stringBuffer.append(this.endl);
                            continue;
                        }
                        stringBuffer.append((char)n);
                    }
                    catch (IOException iOException) {
                        stringBuffer.append(this.endl);
                    }
                }
                this.input = stringBuffer.toString();
                this.input = this.input.substring(0, this.input.indexOf(this.endl));
            }
            if (this.action == null) break block16;
            try {
                XString xString = (XString)this.action.filterStringable(new XString(this.input));
                this.input = xString.getValue();
            }
            catch (FilterException filterException) {}
        }
        return this.input;
    }

    protected String getLineSeparator() {
        return this.endl;
    }

    protected void flush(int n) throws IOException {
        if (!this.isActivated()) {
            this.outStreams[n].flush();
        }
    }

    protected void write(String string, int n) {
        if (string == null) {
            return;
        }
        if (this.isActivated()) {
            this.window.consoleOutputPerformed(string, n);
        } else {
            try {
                this.outStreams[n].write(string.getBytes());
            }
            catch (IOException iOException) {
                System.err.print("Could not write to ");
                switch (n) {
                    case 1: {
                        System.err.print("error");
                        break;
                    }
                    default: {
                        System.err.print("output");
                    }
                }
                System.err.println(" stream.");
                iOException.printStackTrace();
            }
            try {
                this.outStreams[n].flush();
            }
            catch (IOException iOException) {
                System.err.print("Could not flush ");
                switch (n) {
                    case 1: {
                        System.err.print("error");
                        break;
                    }
                    default: {
                        System.err.print("output");
                    }
                }
                System.err.println(" stream.");
                iOException.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ConsoleOutputStream
    extends OutputStream {
        private int stream = 0;

        public ConsoleOutputStream(int n) {
            this.stream = n;
        }

        public void close() {
        }

        public void flush() throws IOException {
            ConsoleGateway.this.flush(this.stream);
        }

        public void write(byte[] byArray) {
            ConsoleGateway.this.write(new String(byArray), this.stream);
        }

        public void write(byte[] byArray, int n, int n2) {
            ConsoleGateway.this.write(new String(byArray, n, n2), this.stream);
        }

        public void write(int n) {
            ConsoleGateway.this.write("" + (char)n, this.stream);
        }
    }

    public class ConsoleInputStream
    implements Serializable {
        protected StringableFactory factory = new StringableFactory(class$edu$neu$ccs$XInt == null ? (class$edu$neu$ccs$XInt = ConsoleGateway.class$("edu.neu.ccs.XInt")) : class$edu$neu$ccs$XInt);

        public void setDataType(Class clazz) {
            this.factory.setDataType(clazz);
        }

        public Class getDataType() {
            return this.factory.getDataType();
        }

        public void demand(String string, Stringable stringable) {
            this.demand(string, null, stringable, null);
        }

        public void demand(String string, Stringable stringable, StringableFilter stringableFilter) {
            this.demand(string, null, stringable, stringableFilter);
        }

        public void demand(String string, String string2, Stringable stringable) {
            this.demand(string, string2, stringable, null);
        }

        public void demand(String string, String string2, Stringable stringable, StringableFilter stringableFilter) {
            while (true) {
                ConsoleGateway.this.prompt(string, string2);
                String string3 = ConsoleGateway.this.getOneLine();
                if (string3.length() == 0 && string2 != null) {
                    string3 = string2;
                }
                try {
                    block8: {
                        try {
                            stringable.fromStringData(string3);
                            if (stringableFilter == null) break block8;
                            try {
                                stringable = stringableFilter.filterStringable(stringable);
                            }
                            catch (FilterException filterException) {
                                throw new ParseException(filterException.getMessage(), -1);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException(numberFormatException.getMessage(), -1);
                        }
                    }
                    return;
                }
                catch (ParseException parseException) {
                    ConsoleGateway.this.err.println(XObject.formatErrorMessage(parseException, string3));
                    continue;
                }
                break;
            }
        }

        public boolean reading(String string, Stringable stringable) {
            return this.reading(string, stringable, null);
        }

        public boolean reading(String string, Stringable stringable, StringableFilter stringableFilter) {
            while (true) {
                ConsoleGateway.this.prompt(string);
                String string2 = ConsoleGateway.this.getOneLine();
                if (string2.length() == 0) {
                    return false;
                }
                try {
                    block8: {
                        try {
                            stringable.fromStringData(string2);
                            if (stringableFilter == null) break block8;
                            try {
                                stringable = stringableFilter.filterStringable(stringable);
                            }
                            catch (FilterException filterException) {
                                throw new ParseException(filterException.getMessage(), -1);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException(numberFormatException.getMessage(), -1);
                        }
                    }
                    return true;
                }
                catch (ParseException parseException) {
                    ConsoleGateway.this.err.println(XObject.formatErrorMessage(parseException, string2));
                    continue;
                }
                break;
            }
        }

        public Stringable demandObject(String string) {
            return this.demandObject(string, null, null);
        }

        public Stringable demandObject(String string, String string2) {
            return this.demandObject(string, string2, null);
        }

        public Stringable demandObject(String string, String string2, StringableFilter stringableFilter) {
            Stringable stringable = this.factory.getDefaultInstance();
            this.demand(string, string2, stringable, stringableFilter);
            return stringable;
        }

        public byte demandByte(String string) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XByte == null ? (class$edu$neu$ccs$XByte = ConsoleGateway.class$("edu.neu.ccs.XByte")) : class$edu$neu$ccs$XByte);
            Stringable stringable = this.demandObject(string);
            XByte xByte = (XByte)stringable;
            this.setDataType(clazz);
            return xByte.getValue();
        }

        public byte demandByte(String string, byte by) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XByte == null ? (class$edu$neu$ccs$XByte = ConsoleGateway.class$("edu.neu.ccs.XByte")) : class$edu$neu$ccs$XByte);
            Stringable stringable = this.demandObject(string, by + "");
            XByte xByte = (XByte)stringable;
            this.setDataType(clazz);
            return xByte.getValue();
        }

        public byte demandByte(String string, byte by, StringableFilter stringableFilter) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XByte == null ? (class$edu$neu$ccs$XByte = ConsoleGateway.class$("edu.neu.ccs.XByte")) : class$edu$neu$ccs$XByte);
            Stringable stringable = this.demandObject(string, by + "", stringableFilter);
            XByte xByte = (XByte)stringable;
            this.setDataType(clazz);
            return xByte.getValue();
        }

        public short demandShort(String string) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XShort == null ? (class$edu$neu$ccs$XShort = ConsoleGateway.class$("edu.neu.ccs.XShort")) : class$edu$neu$ccs$XShort);
            Stringable stringable = this.demandObject(string);
            XShort xShort = (XShort)stringable;
            this.setDataType(clazz);
            return xShort.getValue();
        }

        public short demandShort(String string, short s) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XShort == null ? (class$edu$neu$ccs$XShort = ConsoleGateway.class$("edu.neu.ccs.XShort")) : class$edu$neu$ccs$XShort);
            Stringable stringable = this.demandObject(string, s + "");
            XShort xShort = (XShort)stringable;
            this.setDataType(clazz);
            return xShort.getValue();
        }

        public short demandShort(String string, short s, StringableFilter stringableFilter) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XShort == null ? (class$edu$neu$ccs$XShort = ConsoleGateway.class$("edu.neu.ccs.XShort")) : class$edu$neu$ccs$XShort);
            Stringable stringable = this.demandObject(string, s + "", stringableFilter);
            XShort xShort = (XShort)stringable;
            this.setDataType(clazz);
            return xShort.getValue();
        }

        public int demandInt(String string) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XInt == null ? (class$edu$neu$ccs$XInt = ConsoleGateway.class$("edu.neu.ccs.XInt")) : class$edu$neu$ccs$XInt);
            Stringable stringable = this.demandObject(string);
            XInt xInt = (XInt)stringable;
            this.setDataType(clazz);
            return xInt.getValue();
        }

        public int demandInt(String string, int n) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XInt == null ? (class$edu$neu$ccs$XInt = ConsoleGateway.class$("edu.neu.ccs.XInt")) : class$edu$neu$ccs$XInt);
            Stringable stringable = this.demandObject(string, n + "");
            XInt xInt = (XInt)stringable;
            this.setDataType(clazz);
            return xInt.getValue();
        }

        public int demandInt(String string, int n, StringableFilter stringableFilter) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XInt == null ? (class$edu$neu$ccs$XInt = ConsoleGateway.class$("edu.neu.ccs.XInt")) : class$edu$neu$ccs$XInt);
            Stringable stringable = this.demandObject(string, n + "", stringableFilter);
            XInt xInt = (XInt)stringable;
            this.setDataType(clazz);
            return xInt.getValue();
        }

        public long demandLong(String string) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XLong == null ? (class$edu$neu$ccs$XLong = ConsoleGateway.class$("edu.neu.ccs.XLong")) : class$edu$neu$ccs$XLong);
            Stringable stringable = this.demandObject(string);
            XLong xLong = (XLong)stringable;
            this.setDataType(clazz);
            return xLong.getValue();
        }

        public long demandLong(String string, long l) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XLong == null ? (class$edu$neu$ccs$XLong = ConsoleGateway.class$("edu.neu.ccs.XLong")) : class$edu$neu$ccs$XLong);
            Stringable stringable = this.demandObject(string, l + "");
            XLong xLong = (XLong)stringable;
            this.setDataType(clazz);
            return xLong.getValue();
        }

        public long demandLong(String string, long l, StringableFilter stringableFilter) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XLong == null ? (class$edu$neu$ccs$XLong = ConsoleGateway.class$("edu.neu.ccs.XLong")) : class$edu$neu$ccs$XLong);
            Stringable stringable = this.demandObject(string, l + "", stringableFilter);
            XLong xLong = (XLong)stringable;
            this.setDataType(clazz);
            return xLong.getValue();
        }

        public float demandFloat(String string) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XFloat == null ? (class$edu$neu$ccs$XFloat = ConsoleGateway.class$("edu.neu.ccs.XFloat")) : class$edu$neu$ccs$XFloat);
            Stringable stringable = this.demandObject(string);
            XFloat xFloat = (XFloat)stringable;
            this.setDataType(clazz);
            return xFloat.getValue();
        }

        public float demandFloat(String string, float f) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XFloat == null ? (class$edu$neu$ccs$XFloat = ConsoleGateway.class$("edu.neu.ccs.XFloat")) : class$edu$neu$ccs$XFloat);
            Stringable stringable = this.demandObject(string, f + "");
            XFloat xFloat = (XFloat)stringable;
            this.setDataType(clazz);
            return xFloat.getValue();
        }

        public float demandFloat(String string, float f, StringableFilter stringableFilter) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XFloat == null ? (class$edu$neu$ccs$XFloat = ConsoleGateway.class$("edu.neu.ccs.XFloat")) : class$edu$neu$ccs$XFloat);
            Stringable stringable = this.demandObject(string, f + "", stringableFilter);
            XFloat xFloat = (XFloat)stringable;
            this.setDataType(clazz);
            return xFloat.getValue();
        }

        public double demandDouble(String string) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XDouble == null ? (class$edu$neu$ccs$XDouble = ConsoleGateway.class$("edu.neu.ccs.XDouble")) : class$edu$neu$ccs$XDouble);
            Stringable stringable = this.demandObject(string);
            XDouble xDouble = (XDouble)stringable;
            this.setDataType(clazz);
            return xDouble.getValue();
        }

        public double demandDouble(String string, double d) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XDouble == null ? (class$edu$neu$ccs$XDouble = ConsoleGateway.class$("edu.neu.ccs.XDouble")) : class$edu$neu$ccs$XDouble);
            Stringable stringable = this.demandObject(string, d + "");
            XDouble xDouble = (XDouble)stringable;
            this.setDataType(clazz);
            return xDouble.getValue();
        }

        public double demandDouble(String string, double d, StringableFilter stringableFilter) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XDouble == null ? (class$edu$neu$ccs$XDouble = ConsoleGateway.class$("edu.neu.ccs.XDouble")) : class$edu$neu$ccs$XDouble);
            Stringable stringable = this.demandObject(string, d + "", stringableFilter);
            XDouble xDouble = (XDouble)stringable;
            this.setDataType(clazz);
            return xDouble.getValue();
        }

        public char demandChar(String string) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XChar == null ? (class$edu$neu$ccs$XChar = ConsoleGateway.class$("edu.neu.ccs.XChar")) : class$edu$neu$ccs$XChar);
            Stringable stringable = this.demandObject(string);
            XChar xChar = (XChar)stringable;
            this.setDataType(clazz);
            return xChar.getValue();
        }

        public char demandChar(String string, char c) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XChar == null ? (class$edu$neu$ccs$XChar = ConsoleGateway.class$("edu.neu.ccs.XChar")) : class$edu$neu$ccs$XChar);
            Stringable stringable = this.demandObject(string, c + "");
            XChar xChar = (XChar)stringable;
            this.setDataType(clazz);
            return xChar.getValue();
        }

        public char demandChar(String string, char c, StringableFilter stringableFilter) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XChar == null ? (class$edu$neu$ccs$XChar = ConsoleGateway.class$("edu.neu.ccs.XChar")) : class$edu$neu$ccs$XChar);
            Stringable stringable = this.demandObject(string, c + "", stringableFilter);
            XChar xChar = (XChar)stringable;
            this.setDataType(clazz);
            return xChar.getValue();
        }

        public boolean demandBoolean(String string) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBoolean == null ? (class$edu$neu$ccs$XBoolean = ConsoleGateway.class$("edu.neu.ccs.XBoolean")) : class$edu$neu$ccs$XBoolean);
            Stringable stringable = this.demandObject(string);
            XBoolean xBoolean = (XBoolean)stringable;
            this.setDataType(clazz);
            return xBoolean.getValue();
        }

        public boolean demandBoolean(String string, boolean bl) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBoolean == null ? (class$edu$neu$ccs$XBoolean = ConsoleGateway.class$("edu.neu.ccs.XBoolean")) : class$edu$neu$ccs$XBoolean);
            Stringable stringable = this.demandObject(string, bl + "");
            XBoolean xBoolean = (XBoolean)stringable;
            this.setDataType(clazz);
            return xBoolean.getValue();
        }

        public boolean demandBoolean(String string, boolean bl, StringableFilter stringableFilter) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBoolean == null ? (class$edu$neu$ccs$XBoolean = ConsoleGateway.class$("edu.neu.ccs.XBoolean")) : class$edu$neu$ccs$XBoolean);
            Stringable stringable = this.demandObject(string, bl + "", stringableFilter);
            XBoolean xBoolean = (XBoolean)stringable;
            this.setDataType(clazz);
            return xBoolean.getValue();
        }

        public String demandString(String string) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XString == null ? (class$edu$neu$ccs$XString = ConsoleGateway.class$("edu.neu.ccs.XString")) : class$edu$neu$ccs$XString);
            Stringable stringable = this.demandObject(string);
            XString xString = (XString)stringable;
            this.setDataType(clazz);
            return xString.getValue();
        }

        public String demandString(String string, String string2) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XString == null ? (class$edu$neu$ccs$XString = ConsoleGateway.class$("edu.neu.ccs.XString")) : class$edu$neu$ccs$XString);
            Stringable stringable = this.demandObject(string, string2);
            XString xString = (XString)stringable;
            this.setDataType(clazz);
            return xString.getValue();
        }

        public String demandString(String string, String string2, StringableFilter stringableFilter) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XString == null ? (class$edu$neu$ccs$XString = ConsoleGateway.class$("edu.neu.ccs.XString")) : class$edu$neu$ccs$XString);
            Stringable stringable = this.demandObject(string, string2, stringableFilter);
            XString xString = (XString)stringable;
            this.setDataType(clazz);
            return xString.getValue();
        }

        public BigInteger demandBigInteger(String string) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigInteger == null ? (class$edu$neu$ccs$XBigInteger = ConsoleGateway.class$("edu.neu.ccs.XBigInteger")) : class$edu$neu$ccs$XBigInteger);
            Stringable stringable = this.demandObject(string);
            XBigInteger xBigInteger = (XBigInteger)stringable;
            this.setDataType(clazz);
            return xBigInteger.getValue();
        }

        public BigInteger demandBigInteger(String string, BigInteger bigInteger) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigInteger == null ? (class$edu$neu$ccs$XBigInteger = ConsoleGateway.class$("edu.neu.ccs.XBigInteger")) : class$edu$neu$ccs$XBigInteger);
            Stringable stringable = this.demandObject(string, bigInteger + "");
            XBigInteger xBigInteger = (XBigInteger)stringable;
            this.setDataType(clazz);
            return xBigInteger.getValue();
        }

        public BigInteger demandBigInteger(String string, BigInteger bigInteger, StringableFilter stringableFilter) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigInteger == null ? (class$edu$neu$ccs$XBigInteger = ConsoleGateway.class$("edu.neu.ccs.XBigInteger")) : class$edu$neu$ccs$XBigInteger);
            Stringable stringable = this.demandObject(string, bigInteger + "", stringableFilter);
            XBigInteger xBigInteger = (XBigInteger)stringable;
            this.setDataType(clazz);
            return xBigInteger.getValue();
        }

        public BigDecimal demandBigDecimal(String string) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigDecimal == null ? (class$edu$neu$ccs$XBigDecimal = ConsoleGateway.class$("edu.neu.ccs.XBigDecimal")) : class$edu$neu$ccs$XBigDecimal);
            Stringable stringable = this.demandObject(string);
            XBigDecimal xBigDecimal = (XBigDecimal)stringable;
            this.setDataType(clazz);
            return xBigDecimal.getValue();
        }

        public BigDecimal demandBigDecimal(String string, BigDecimal bigDecimal) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigDecimal == null ? (class$edu$neu$ccs$XBigDecimal = ConsoleGateway.class$("edu.neu.ccs.XBigDecimal")) : class$edu$neu$ccs$XBigDecimal);
            Stringable stringable = this.demandObject(string, bigDecimal + "");
            XBigDecimal xBigDecimal = (XBigDecimal)stringable;
            this.setDataType(clazz);
            return xBigDecimal.getValue();
        }

        public BigDecimal demandBigDecimal(String string, BigDecimal bigDecimal, StringableFilter stringableFilter) {
            Class clazz = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigDecimal == null ? (class$edu$neu$ccs$XBigDecimal = ConsoleGateway.class$("edu.neu.ccs.XBigDecimal")) : class$edu$neu$ccs$XBigDecimal);
            Stringable stringable = this.demandObject(string, bigDecimal + "", stringableFilter);
            XBigDecimal xBigDecimal = (XBigDecimal)stringable;
            this.setDataType(clazz);
            return xBigDecimal.getValue();
        }
    }
}

