/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XBoolean
extends XObject {
    private boolean value = false;

    public XBoolean() {
    }

    public XBoolean(boolean bl) {
        this.value = bl;
    }

    public XBoolean(String string) throws ParseException {
        this.fromStringData(string);
    }

    public void fromStringData(String string) throws ParseException {
        boolean bl = this.value;
        Parser parser = ParserUtilities.getDefaultParser();
        Object object = parser.parse(string);
        if (!(object instanceof XBoolean)) {
            throw new ParseException("Expected boolean value.", string.length());
        }
        XBoolean xBoolean = (XBoolean)object;
        this.value = xBoolean.getValue();
        this.changeAdapter.firePropertyChange("value", new Boolean(bl), string);
    }

    public String toStringData() {
        return this.value + "";
    }

    public boolean equals(Object object) {
        if (object instanceof XBoolean) {
            return this.getValue() == ((XBoolean)object).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Boolean(this.getValue()).hashCode();
    }

    public String toString() {
        return this.value + "";
    }

    public void setValue(boolean bl) {
        boolean bl2 = this.value;
        this.value = bl;
        if (this.getValue() != bl2) {
            this.changeAdapter.firePropertyChange("value", new Boolean(bl2), new Boolean(this.getValue()));
        }
    }

    public boolean getValue() {
        return this.value;
    }

    public static boolean parseBoolean(String string) throws NumberFormatException {
        try {
            return new XBoolean((String)string).value;
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(XObject.formatErrorMessage(parseException, string));
        }
    }

    public static boolean[] toPrimitiveArray(XBoolean[] xBooleanArray) {
        if (xBooleanArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[xBooleanArray.length];
        int n = 0;
        while (n < blArray.length) {
            if (xBooleanArray[n] != null) {
                blArray[n] = xBooleanArray[n].getValue();
            }
            ++n;
        }
        return blArray;
    }

    public static XBoolean[] toXArray(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        XBoolean[] xBooleanArray = new XBoolean[blArray.length];
        int n = 0;
        while (n < xBooleanArray.length) {
            xBooleanArray[n] = new XBoolean(blArray[n]);
            ++n;
        }
        return xBooleanArray;
    }
}

