/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern:
        iterator for a list of cities 
*/

class ListRange implements IRange {

    /*-------------------------------------------------------- 
     Member data
     *------------------------------------------------------*/
    AListOfCities ptr; /* reference to this list */
    
    /*-------------------------------------------------------- 
     Constructor
     *------------------------------------------------------*/
    ListRange(AListOfCities aList) { this.ptr = aList; }
        
    /*--------------------------------------------------------
     Methods to implement the IRange interface
     *------------------------------------------------------*/

    public void next() {
        this.ptr = ((ConsListOfCities)this.ptr).rest; 
    }


    public Object current() {
        return ((ConsListOfCities)this.ptr).first; 
    }
    
    public boolean hasMore() {
        return (this.ptr instanceof ConsListOfCities); 
    }
}
        
