/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern:
        iterator for a list of cities 
*/

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import javax.swing.*;
import java.util.*;

/** An input iterator for City object from file input. */
class InFileRange implements IRange{
    
    /*-------------------------------------------------------- 
     Member data
     *------------------------------------------------------*/
    
    /* the input String read from the file */
    protected String inString;
    
    /* string tokenizer to extract Balloons from inString */
    protected StringTokenizer st;
    
    /* a city object to hold values */
    protected City c = new City();
    
    /* determines whether the general dialog has been closed */
    protected boolean closed = true;
    
    /* determines whether new baloon data has been submitted */
    protected boolean submitted = false;
    
    /*-------------------------------------------------------- 
     Constructor
     *------------------------------------------------------*/    
    public InFileRange() {
                      
        /** build a file chooser 
            and have the user choose a file, 
            quitting this operation 
            if the user cancelled the choice */
        JFileChooser chooser = new JFileChooser(".");
        
        /** set the file extension to be .txt */
        chooser.setFileFilter(new FileView.ExtensionFileFilter("txt"));
        
        /** see if file was selected - quit if user canceled */
        if (chooser.showOpenDialog(null) != JFileChooser.APPROVE_OPTION) {
            closed = true;
            return;
        }
        
        /** read all input from the selected file */
        try{
            inString = FileUtilities.readFile(
            	chooser.getSelectedFile());     // OK to overwrite existing file
            /** read successful */
            closed = false;
        }
        catch(Exception e) {
       	    System.out.println("Exception: " + e);
       	    closed = true;
        }
        
        if (!closed){
            /** set up the string tokenizer to extract balloon data */
            st = new StringTokenizer(inString, "\n");

            /* extract values for the first balloon */
            next();
        }  
    }
    /*--------------------------------------------------------
     Methods to implement the IRange interface
     *------------------------------------------------------*/

    /** process next item, if available */
    public void next() {

        if (st.hasMoreTokens())
            read(st.nextToken());
        else
            closed = true;
    }

    /** return the nmost recent submission - if available */
    public Object current() {
           
        if (!closed)
            return c;
        else
            return null;
    }
    
    /** verify that new submission is available */
    public boolean hasMore() {
        return (!closed); 
    }
    
    /** extract next Balloon object from the input string */
    public void read(String s){
        
        try {
            c.fromStringData(s);
        }
        catch(java.text.ParseException e){
            System.out.println(e.getMessage());
            c = null;
            closed = true;
        }
        
    }
    
}