/*
 * @(#)CityView.java  16 April 2003
 *
 * @author Viera K. Proulx
 */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.geom.*;
import java.text.NumberFormat;
import java.text.DecimalFormat;
import javax.swing.*;

/**
 * View for input and manipulation of a City object.
 */
public class CityView
    implements JPTConstants {
    
    ///////////////
    // Constants //
    ///////////////
    
	/** Default label for the x coordinate text field view */
	public static final String DEFAULT_LABELz = "Zip Code:";
    
    /** Default label for the y coordinate text field view */
	public static final String DEFAULT_LABELc = "City:";
    
    /** Default label for the y coordinate text field view */
	public static final String DEFAULT_LABELs = "State:";
    
    /** Default label for the y coordinate text field view */
	public static final String DEFAULT_LABELa = "Area Code:";
    
    /** Default layout orientation for the Point2DView . */
    public static final int DEFAULT_ORIENTATION = VERTICAL;
    
    /////////////////
    // Member Data //
    /////////////////
    
    /** Balloon number for reference */    
    protected City c;
    
	/** The view to be used in input GUIs */
	public Display cView = new Display();

    /** Display field for the zip code. */
    protected TextFieldView zTFV;

    /** Display field for the city name. */
    protected TextFieldView cTFV;

    /** Display field for the state. */
    protected TextFieldView sTFV;

    /** Display field for the area code. */
    protected TextFieldView aTFV;

    /** Property list for this view object. */
    protected InputProperties properties = new InputProperties();
    
    public CityView() {
		super();
		
		/* record the information about this city */
   	    this.c = new City();
   	    		
 		// add the internal panel to the Display
		cView = new Display();
		cView.add(createDisplay());
		
		// set the title and annotation for the Display
		cView.setTitleText("City");
		
    }
    
    //////////////////////////////////
    // Helpers for the Constructors //
    //////////////////////////////////
    
    /**
     * Construct a table panel display for one balloon, containing
     * three text field views, sliders, and color view
     */
    protected TablePanel createDisplay() {
    	
        createTFVset();
        
        TablePanel cityDisplay = new TablePanel(new Object[][]{
            {DEFAULT_LABELz, zTFV},
            {DEFAULT_LABELc, cTFV},
            {DEFAULT_LABELs, sTFV},
            {DEFAULT_LABELa, aTFV}},
            VERTICAL, 5, 5);
        
        return cityDisplay;        	
                	        
    }
    

	/**
	 * Creates four text field views with the desired default values
	 */
    protected void createTFVset() {
    
    	zTFV = new TextFieldView(
    		"" + 10027,
	        "Please enter an integer:",
	        "zip code error",80);	             
    	cTFV = new TextFieldView(80);
    	sTFV = new TextFieldView(80);
    	aTFV = new TextFieldView(
	        "" + 212,
	        "Please enter an integer:",
	        "area code error",
	        80);
	        
	    zTFV.setDefaultViewState("10027");
	    cTFV.setDefaultViewState("New York");	    
	    sTFV.setDefaultViewState("NY");	
	    aTFV.setDefaultViewState("" + 212);	
    }


    /* set the view state from the current state of the city */
    public void setViewState(){
        zTFV.setViewState("" + c.zip);
        cTFV.setViewState("" + c.name);
        sTFV.setViewState("" + c.state);
        aTFV.setViewState("" + c.area);
    }

    public City getCity(){
        c.zip   = zTFV.demandInt();
        c.name  = cTFV.demandString();
        c.state = sTFV.demandString();
        c.area  = aTFV.demandInt();
        return c;
    }

}