/*
 * @(#)City.java  1.0  16 April 2003
 *
 * @author Viera K. Proulx
 */

import edu.neu.ccs.gui.*;	// to get BufferedPanel
import edu.neu.ccs.*;	    // to get XInt
import java.util.*;         // to get StringTokenizer
import java.text.*;         // to get ParseException

/** A simple class to use for learning about classes and objects. */
class City implements Stringable{
    
    /*-------------------------------------------------------------------------
     Member data 
     *-----------------------------------------------------------------------*/
    
    /** The zip code for this city. */
    public int zip;
    
    /** The name of this city. */
    public String name;
    
    /** The state for this city */
    public String state;
    
    /* The area code for this city */
    public int area;

    /* Decimal format to print leading zeros in zip code */
    public DecimalFormat zipFormat = new DecimalFormat("00000");

    /*-------------------------------------------------------------------------
     Constructor
     *-----------------------------------------------------------------------*/
    
    /* full constructor */
    public City (int aZip, String aName, String aState, int anArea){
        this.zip   = aZip;
        this.name  = aName;
        this.state = aState;
        this.area  = anArea;
    }
    
    /** copy constructor */
    public City(City aCity){
        this(aCity.zip, aCity.name, aCity.state, aCity.area);
    }
    
    public City (String aZip, String aName, String aState, int anArea){
        this.zip   = decimal(aZip);
        this.name  = aName;
        this.state = aState;
        this.area  = anArea;
    }
    
    /** default constructor */
    public City(){
        this.zip   = 10027;
        this.name  = "New York";
        this.state = "NY";
        this.area  = 212;
    }

    /*-------------------------------------------------------------------------
     Methods 
     *-----------------------------------------------------------------------*/
        
    /** determine whether this city is in the given state */
    boolean isInState(String aState){
        return state.equals(aState);
    }
    
        
    /*-------------------------------------------------------------------------
     Stringable interface
     *-----------------------------------------------------------------------*/
    /** city data to string for file output*/
    public String toStringData(){
    	String s = "" + zipFormat.format(this.zip) + ", " +
    	           this.name  + ", " +
    	           this.state + ", " +
    	           this.area  + "\n";
    	return s;
    }
    
    /** string to balloon data */
    public void fromStringData(String s) throws java.text.ParseException{

        try{
            /** set up the string tokenizer to extract city data */
            StringTokenizer st = new StringTokenizer(s, ",");

            this.zip   = decimal(st.nextToken());
            this.name  = st.nextToken();
            this.state = st.nextToken();
            this.area  = intValue(st.nextToken());
        }
        catch(NoSuchElementException e){
            System.out.println(e.getMessage());
            throw new java.text.ParseException("Tokenizer Error", 0);
        }
    }
    
    /** convert a String to int - if possible */
    protected int intValue(String s) throws ParseException{

        return (new XInt(s)).intValue();
    }    
    
    /*-------------------------------------------------------------------------
     Console print
     *-----------------------------------------------------------------------*/
    /** print the city data */
    public String toString(){
    	return ("new " + getClass() + "(" + 
    	        zipFormat.format(this.zip)   + ",   " + 
    	        this.name  + ",  " + 
    	        this.state + ", " + 
    	        this.area  + ")\n");
    }
    
    /** helper method to convert zip code string to integer */
    public int decimal(String s){
    
    	char[] c = s.toCharArray();
    	int n = 0;
    	try {
    	for (int i = 0; i < 5; i++){
    		n = 10 * n + intValue("" + c[i]);
    	}
    	}
    	catch(ParseException e){
    		System.out.println("Converting zip to int " + e);
    	}
    	return n;
    }
    
}
