/*
 * Decompiled with CFR 0.152.
 */
import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.gui.ActionsPanel;
import edu.neu.ccs.gui.BufferedPanel;
import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.Display;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.ThreadedAction;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Component;
import java.awt.LayoutManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;

public class JPFApplicationAlt
extends DisplayPanel
implements JPTConstants,
ConsoleAware {
    public static final int BUFFER_WIDTH = 400;
    public static final int BUFFER_HEIGHT = 400;
    protected BufferedPanel window = new BufferedPanel(400, 400);
    protected JPFalt initializer = null;
    protected Class initializerClass = null;
    protected JPTFrame frame = null;
    protected String frameTitle = null;
    protected boolean showGraphicsWindow = true;
    protected final int MAXIMUM_ROWS = 25;
    protected ActionsPanel buttons = new ActionsPanel((LayoutManager)new TableLayout(25, 1, 0, 0, 0, 0));
    protected DisplayPanel LHS = null;
    protected DisplayPanel RHS = null;
    protected TablePanel mainPanel = null;
    protected Object inMethodMutex = new Object();
    protected String inMethod = null;
    static /* synthetic */ Class class$JPFalt;
    static /* synthetic */ Class class$edu$neu$ccs$Stringable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$awt$geom$Point2D$Double;

    protected JPFApplicationAlt(JPFalt jPFalt, String string) {
        if (jPFalt == null) {
            return;
        }
        this.initializer = jPFalt;
        this.initializerClass = jPFalt.getClass();
        this.setFrameTitle(string);
        this.buildButtons();
        this.buildGUI();
        this.frame = JPTFrame.createQuickJPTFrame((String)this.getFrameTitle(), (Component)((Object)this), (LayoutManager)new CenterLayout(), (int)2);
    }

    public BufferedPanel getGraphicsWindow() {
        return this.window;
    }

    public String getFrameTitle() {
        return this.frameTitle;
    }

    public void setFrameTitle(String string) {
        String string2 = this.frameTitle = string != null ? string : this.className(this.initializerClass);
        if (this.frame != null) {
            this.frame.setTitle(this.frameTitle);
        }
    }

    protected void buildButtons() {
        Method[] methodArray = this.getMethodList();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (methodArray[n2] != null) {
                this.addOneButton(this.makeActionFromMethod(methodArray[n2]), this.getMethodToolTip(methodArray[n2]));
            }
            ++n2;
        }
        this.addOneButton((Action)new SimpleAction("Clear Graphics"){

            public void perform() {
                JPFApplicationAlt.this.clearGraphics();
            }
        }, "Clear the Graphics Window");
        this.addOneButton((Action)new SimpleAction("Toggle Graphics"){

            public void perform() {
                JPFApplicationAlt.this.toggleGraphics();
            }
        }, "Show or Hide the Graphics Window");
        this.addOneButton((Action)new SimpleAction("Exit"){

            public void perform() {
                JPFApplicationAlt.this.exitFramework();
            }
        }, "Exit the Framework");
        this.buttons.uniformizeSize();
    }

    protected void clearGraphics() {
        this.window.clearPanel();
        this.window.repaint();
    }

    protected void toggleGraphics() {
        if (this.showGraphicsWindow) {
            this.mainPanel.remove((Component)this.RHS);
        } else {
            this.mainPanel.add((Component)this.RHS);
        }
        this.showGraphicsWindow = !this.showGraphicsWindow;
        this.frame.pack();
        this.frame.setLocation(2);
    }

    protected void exitFramework() {
        ConsoleAware.console.setActivated(false);
        System.exit(0);
    }

    protected void addOneButton(Action action, String string) {
        this.buttons.addAction(action);
        this.buttons.findMatchedButton(action).setToolTipText(string);
    }

    protected String getMethodToolTip(Method method) {
        if (method == null) {
            return "";
        }
        return (this.isStatic(method) ? "static " : "") + this.className(method.getReturnType()) + " " + method.getName() + "(" + this.getParameterNames(method) + ")" + " in " + this.className(method.getDeclaringClass());
    }

    protected String getParameterNames(Method method) {
        String string = "";
        if (method == null) {
            return string;
        }
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        if (n == 0) {
            return string;
        }
        string = this.className(classArray[0]);
        int n2 = 1;
        while (n2 < n) {
            string = string + ", " + this.className(classArray[n2]);
            ++n2;
        }
        return string;
    }

    protected void buildGUI() {
        this.showConsole();
        this.LHS = new Display((Displayable)this.buttons, null, "Tasks");
        this.RHS = new Display((Displayable)this.window, null, "Graphics");
        this.mainPanel = new TablePanel(new Object[]{this.LHS, this.RHS}, 0, 5, 5, 1);
        this.add((Component)this.mainPanel);
    }

    protected void showConsole() {
        ConsoleAware.console.setActivated(true);
        ConsoleAware.console.selectColorTextScheme();
    }

    protected Method[] getMethodList() {
        Method[] methodArray = this.getExtraMethods(this.initializerClass, class$JPFalt == null ? (class$JPFalt = JPFApplicationAlt.class$("JPFalt")) : class$JPFalt);
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!this.isSimpleMethod(methodArray[n2]) && !this.isGUIMethod(methodArray[n2])) {
                methodArray[n2] = null;
            }
            ++n2;
        }
        this.removeDuplicateVirtualMethods(methodArray);
        return methodArray;
    }

    protected void removeDuplicateVirtualMethods(Method[] methodArray) {
        if (methodArray == null) {
            return;
        }
        int n = methodArray.length;
        int n2 = n - 1;
        while (n2 > 0) {
            if (methodArray[n2] != null && !this.isStatic(methodArray[n2])) {
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    if (methodArray[n3] != null && !this.isStatic(methodArray[n3]) && this.isDuplicate(methodArray[n2], methodArray[n3])) {
                        methodArray[n3] = null;
                    }
                    --n3;
                }
            }
            --n2;
        }
    }

    protected boolean isDuplicate(Method method, Method method2) {
        if (method == null || method2 == null) {
            return false;
        }
        return method.getName().equals(method2.getName()) && method.getModifiers() == method2.getModifiers() && method2.getReturnType() == method2.getReturnType() && this.isDuplicateParameterList(method, method2);
    }

    protected boolean isDuplicateParameterList(Method method, Method method2) {
        Class<?>[] classArray;
        int n;
        if (method == null || method2 == null) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        int n2 = classArray2.length;
        if (n2 != (n = (classArray = method2.getParameterTypes()).length)) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (classArray2[n3] != classArray[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected Action makeActionFromMethod(final Method method) {
        if (method == null) {
            return null;
        }
        String string = this.isStatic(method) ? this.className(method.getDeclaringClass()) + "." + method.getName() : method.getName();
        return new ThreadedAction((Action)new SimpleAction(string){

            public void perform() {
                JPFApplicationAlt.this.performAction(method);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performAction(Method method) {
        Object object;
        String string = method.getName();
        Object object2 = this.inMethodMutex;
        synchronized (object2) {
            if (this.inMethod != null) {
                GeneralDialog.showOKDialog((Object)("You are already running \"" + this.inMethod + "\" \n" + "Please wait for it to terminate."), (String)"Patience is a virtue");
                return;
            }
            this.inMethod = string;
        }
        try {
            try {
                if (this.isGUIMethod(method)) {
                    this.performActionUsingGUI(method);
                }
                if (this.isStatic(method)) {
                    method.invoke(null, null);
                }
                method.invoke((Object)this.initializer, null);
            }
            catch (Exception exception) {
                this.handleMethodException(exception, string);
                Object var6_5 = null;
                Object object3 = this.inMethodMutex;
                synchronized (object3) {
                    this.inMethod = null;
                    return;
                }
            }
            Object var6_4 = null;
            object = this.inMethodMutex;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Object object4 = this.inMethodMutex;
            synchronized (object4) {
                this.inMethod = null;
                throw throwable;
            }
        }
        synchronized (object) {
            this.inMethod = null;
            return;
        }
    }

    protected void handleMethodException(Exception exception, String string) {
        if (exception instanceof IllegalAccessException) {
            IllegalAccessException illegalAccessException = (IllegalAccessException)exception;
            ConsoleAware.console.err.print("IllegalAccessException: ");
            ConsoleAware.console.err.println("" + illegalAccessException);
            ConsoleAware.console.err.println("In: " + string + "\n");
        } else if (exception instanceof IllegalArgumentException) {
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)exception;
            ConsoleAware.console.err.print("IllegalArgumentException: ");
            ConsoleAware.console.err.println("" + illegalArgumentException);
            ConsoleAware.console.err.println("In: " + string + "\n");
        } else if (exception instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
            Throwable throwable = invocationTargetException.getTargetException();
            ConsoleAware.console.err.println("Exception: " + throwable + "\nIn: " + string);
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            if (stackTraceElementArray != null) {
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stackTraceElementArray[n2] + "";
                    if (string2.startsWith("sun.reflect.")) break;
                    ConsoleAware.console.err.println("    at: " + string2);
                    ++n2;
                }
                ConsoleAware.console.err.println();
            }
        } else {
            ConsoleAware.console.err.println("Exception: " + exception + "\nIn: " + string + "\n");
        }
    }

    public synchronized void performActionUsingGUI(Method method) {
        JPTFrame.createQuickJPTFrame((String)(method.getName() + " evaluator"), (Component)((Object)new MethodGUIalt(this, method)), (LayoutManager)new CenterLayout(), (int)0);
    }

    protected boolean isSimpleMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getName().equals("main")) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        int n = method.getModifiers();
        return (n & 4) == 0 && (n & 2) == 0;
    }

    protected boolean isGUIMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getName().equals("main")) {
            return false;
        }
        if (!this.isAcceptableMethodForGUI(method)) {
            return false;
        }
        int n = method.getModifiers();
        return (n & 4) == 0 && (n & 2) == 0;
    }

    protected boolean isAcceptableTypeForGUI(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        if ((class$edu$neu$ccs$Stringable == null ? (class$edu$neu$ccs$Stringable = JPFApplicationAlt.class$("edu.neu.ccs.Stringable")) : class$edu$neu$ccs$Stringable).isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JPFApplicationAlt.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        if (clazz.equals(class$java$awt$Color == null ? (class$java$awt$Color = JPFApplicationAlt.class$("java.awt.Color")) : class$java$awt$Color)) {
            return true;
        }
        if (clazz.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = JPFApplicationAlt.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return true;
        }
        if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JPFApplicationAlt.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return true;
        }
        return clazz.equals(class$java$awt$geom$Point2D$Double == null ? (class$java$awt$geom$Point2D$Double = JPFApplicationAlt.class$("java.awt.geom.Point2D$Double")) : class$java$awt$geom$Point2D$Double);
    }

    protected boolean isAcceptableMethodForGUI(Method method) {
        if (method == null) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        if (clazz.equals(Void.TYPE) && n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.isAcceptableTypeForGUI(classArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected Method[] getExtraMethods(Class clazz, Class clazz2) {
        if (clazz == null || clazz.equals(clazz2) || clazz.isPrimitive() || clazz.isInterface() || clazz.isArray()) {
            return new Method[0];
        }
        return this.joinMethodArrays(this.getExtraMethods(clazz.getSuperclass(), clazz2), clazz.getDeclaredMethods());
    }

    protected Method[] joinMethodArrays(Method[] methodArray, Method[] methodArray2) {
        int n = methodArray.length;
        int n2 = methodArray2.length;
        int n3 = n + n2;
        Method[] methodArray3 = new Method[n3];
        int n4 = 0;
        while (n4 < n) {
            methodArray3[n4] = methodArray[n4];
            ++n4;
        }
        int n5 = n;
        while (n5 < n3) {
            methodArray3[n5] = methodArray2[n5 - n];
            ++n5;
        }
        return methodArray3;
    }

    protected boolean isStatic(Method method) {
        if (method == null) {
            return false;
        }
        int n = method.getModifiers();
        return (n & 8) != 0;
    }

    protected String className(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

