/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.CellPosition;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;

public class TableLayout
implements LayoutManager2,
JPTConstants {
    public static final int DEFAULT_ALIGNMENT = 6;
    public static final int DEFAULT_ORIENTATION = 0;
    public static final int NO_ALIGNMENT_SET = 36;
    public static final int INVALID_ALIGNMENT = 37;
    public static final int NO_MINIMUM_SET = -1;
    protected int rows = 0;
    protected int cols = 0;
    protected int hgap = 0;
    protected int vgap = 0;
    protected Component[][] table = new Component[0][0];
    protected int orientation = 0;
    protected int tableAlignment = 6;
    protected int[] rowAlignment = new int[0];
    protected int[] colAlignment = new int[0];
    protected int[][] cellAlignment = new int[0][0];
    protected int[] minRowHeight = new int[0];
    protected int[] minColWidth = new int[0];

    public TableLayout(int n, int n2) {
        this(n, n2, 0, 0, 6, 0);
    }

    public TableLayout(int n, int n2, int n3) {
        this(n, n2, 0, 0, n3, 0);
    }

    public TableLayout(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 6);
    }

    public TableLayout(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0);
    }

    public TableLayout(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setRows(n);
        this.setColumns(n2);
        this.setHorizontalGap(n3);
        this.setVerticalGap(n4);
        this.setTableAlignment(n5);
        this.setOrientation(n6);
    }

    public void addLayoutComponent(Component component, Object object) {
        CellPosition cellPosition = null;
        if (object instanceof CellPosition) {
            cellPosition = (CellPosition)object;
        }
        if (cellPosition == null) {
            cellPosition = this.getNextAvailablePosition();
        }
        if (cellPosition == null) {
            cellPosition = this.getOrientation() == 1 ? new CellPosition(this.rows, 0) : new CellPosition(0, this.cols);
        }
        if (cellPosition.row < 0) {
            cellPosition.row = 0;
        }
        if (cellPosition.col < 0) {
            cellPosition.col = 0;
        }
        if (cellPosition.row >= this.rows) {
            this.setRows(cellPosition.row + 1);
        }
        if (cellPosition.col >= this.cols) {
            this.setColumns(cellPosition.col + 1);
        }
        this.table[cellPosition.row][cellPosition.col] = component;
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, this.getNextAvailablePosition());
    }

    public void removeLayoutComponent(Component component) {
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                if (component == this.table[n][n2]) {
                    this.table[n][n2] = null;
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Insets insets = null;
        insets = container != null ? container.getInsets() : new Insets(0, 0, 0, 0);
        this.layoutContainer(this.preferredColumnWidths(), this.preferredRowHeights(), insets);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rows) {
            n = this.minimumRowHeight(n3);
            if (n > 0) {
                if (n2 > 0) {
                    n2 += this.vgap;
                }
                n2 += n;
            }
            ++n3;
        }
        n = 0;
        int n4 = 0;
        while (n4 < this.cols) {
            int n5 = this.minimumColumnWidth(n4);
            if (n5 > 0) {
                if (n > 0) {
                    n += this.hgap;
                }
                n += n5;
            }
            ++n4;
        }
        Insets insets = null;
        insets = container != null ? container.getInsets() : new Insets(0, 0, 0, 0);
        return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rows) {
            n = this.preferredRowHeight(n3);
            if (n > 0) {
                if (n2 > 0) {
                    n2 += this.vgap;
                }
                n2 += n;
            }
            ++n3;
        }
        n = 0;
        int n4 = 0;
        while (n4 < this.cols) {
            int n5 = this.preferredColumnWidth(n4);
            if (n5 > 0) {
                if (n > 0) {
                    n += this.hgap;
                }
                n += n5;
            }
            ++n4;
        }
        Insets insets = null;
        insets = container != null ? container.getInsets() : new Insets(0, 0, 0, 0);
        return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public Dimension maximumLayoutSize(Container container) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rows) {
            n = this.maximumRowHeight(n3);
            if (n > 0) {
                if (n2 > 0) {
                    n2 += this.vgap;
                }
                n2 += n;
            }
            ++n3;
        }
        n = 0;
        int n4 = 0;
        while (n4 < this.cols) {
            int n5 = this.maximumColumnWidth(n4);
            if (n5 > 0) {
                if (n > 0) {
                    n += this.hgap;
                }
                n += n5;
            }
            ++n4;
        }
        Insets insets = null;
        insets = container != null ? container.getInsets() : new Insets(0, 0, 0, 0);
        return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public Component[][] getComponentTable() {
        Component[][] componentArray = new Component[this.rows][this.cols];
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                componentArray[n][n2] = this.table[n][n2];
                ++n2;
            }
            ++n;
        }
        return componentArray;
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.cols;
    }

    public boolean isValidRow(int n) {
        return n >= 0 && n < this.rows;
    }

    public boolean isValidColumn(int n) {
        return n >= 0 && n < this.cols;
    }

    public boolean isEmptyRow(int n) {
        if (!this.isValidRow(n)) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.cols) {
            if (this.table[n][n2] != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isEmptyColumn(int n) {
        if (!this.isValidColumn(n)) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.rows) {
            if (this.table[n2][n] != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void setHorizontalGap(int n) {
        if (n >= 0) {
            this.hgap = n;
        }
    }

    public int getHorizontalGap() {
        return this.hgap;
    }

    public void setVerticalGap(int n) {
        if (n >= 0) {
            this.vgap = n;
        }
    }

    public int getVerticalGap() {
        return this.vgap;
    }

    public void setOrientation(int n) {
        switch (n) {
            case -1: {
                n = 0;
            }
            case 0: 
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setTableAlignment(int n) {
        int n2;
        if ((n = this.adjustAlignment(n)) == 37 || n == 36) {
            return;
        }
        this.tableAlignment = n;
        int n3 = 0;
        while (n3 < this.rows) {
            this.rowAlignment[n3] = n;
            n2 = 0;
            while (n2 < this.cols) {
                this.cellAlignment[n3][n2] = n;
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.cols) {
            this.colAlignment[n2] = n;
            ++n2;
        }
    }

    public int getTableAlignment() {
        return this.tableAlignment;
    }

    public void setRowAlignment(int n, int n2) {
        if (!this.isValidRow(n)) {
            return;
        }
        if ((n2 = this.adjustAlignment(n2)) == 37) {
            return;
        }
        this.rowAlignment[n] = n2;
        int n3 = 0;
        while (n3 < this.cols) {
            this.cellAlignment[n][n3] = n2;
            ++n3;
        }
    }

    public int getRowAlignment(int n) {
        if (!this.isValidRow(n)) {
            return 36;
        }
        return this.rowAlignment[n];
    }

    public void setColumnAlignment(int n, int n2) {
        if (!this.isValidColumn(n)) {
            return;
        }
        if ((n2 = this.adjustAlignment(n2)) == 37) {
            return;
        }
        this.colAlignment[n] = n2;
        int n3 = 0;
        while (n3 < this.rows) {
            this.cellAlignment[n3][n] = n2;
            ++n3;
        }
    }

    public int getColumnAlignment(int n) {
        if (!this.isValidColumn(n)) {
            return 36;
        }
        return this.colAlignment[n];
    }

    public void setCellAlignment(CellPosition cellPosition, int n) {
        if (cellPosition != null) {
            this.setCellAlignmentImpl(cellPosition.row, cellPosition.col, n);
        }
    }

    public void setCellAlignment(int n, int n2, int n3) {
        this.setCellAlignmentImpl(n, n2, n3);
    }

    public int getCellAlignment(CellPosition cellPosition) {
        if (cellPosition != null) {
            return this.getCellAlignment(cellPosition.row, cellPosition.col);
        }
        return this.tableAlignment;
    }

    public int getCellAlignment(int n, int n2) {
        if (this.isValidRow(n) && this.isValidColumn(n2)) {
            return this.cellAlignment[n][n2];
        }
        return this.tableAlignment;
    }

    public int getEffectiveCellAlignment(CellPosition cellPosition) {
        if (cellPosition != null) {
            return this.getEffectiveCellAlignment(cellPosition.row, cellPosition.col);
        }
        return this.tableAlignment;
    }

    public int getEffectiveCellAlignment(int n, int n2) {
        if (this.isValidRow(n) && this.isValidColumn(n2) && this.cellAlignment[n][n2] != 36) {
            return this.cellAlignment[n][n2];
        }
        return this.tableAlignment;
    }

    public void setMinimumRowHeight(int n, int n2) {
        if (!this.isValidRow(n)) {
            return;
        }
        if (n2 < -1) {
            return;
        }
        this.minRowHeight[n] = n2;
    }

    public int getMinimumRowHeight(int n) {
        if (this.isValidRow(n)) {
            return this.minRowHeight[n];
        }
        return -1;
    }

    public void setAllMinimumRowHeights(int n) {
        if (n < -1) {
            return;
        }
        int n2 = 0;
        while (n2 < this.rows) {
            this.minRowHeight[n2] = n;
            ++n2;
        }
    }

    public void setMinimumColumnWidth(int n, int n2) {
        if (!this.isValidColumn(n)) {
            return;
        }
        if (n2 < -1) {
            return;
        }
        this.minColWidth[n] = n2;
    }

    public int getMinimumColumnWidth(int n) {
        if (this.isValidColumn(n)) {
            return this.minColWidth[n];
        }
        return -1;
    }

    public void setAllMinimumColumnWidths(int n) {
        if (n < -1) {
            return;
        }
        int n2 = 0;
        while (n2 < this.cols) {
            this.minColWidth[n2] = n;
            ++n2;
        }
    }

    public int minimumRowHeight(int n) {
        if (!this.isValidRow(n)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.cols) {
            if (this.table[n][n3] != null) {
                n2 = Math.max(n2, this.table[n][n3].getMinimumSize().height);
            }
            ++n3;
        }
        if (n2 > 0) {
            n2 = Math.max(n2, this.minRowHeight[n]);
        }
        return n2;
    }

    public int minimumColumnWidth(int n) {
        if (!this.isValidColumn(n)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rows) {
            if (this.table[n3][n] != null) {
                n2 = Math.max(n2, this.table[n3][n].getMinimumSize().width);
            }
            ++n3;
        }
        if (n2 > 0) {
            n2 = Math.max(n2, this.minColWidth[n]);
        }
        return n2;
    }

    public int preferredRowHeight(int n) {
        if (!this.isValidRow(n)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.cols) {
            if (this.table[n][n3] != null) {
                n2 = Math.max(n2, this.table[n][n3].getPreferredSize().height);
            }
            ++n3;
        }
        if (n2 > 0) {
            n2 = Math.max(n2, this.minRowHeight[n]);
        }
        return n2;
    }

    public int preferredColumnWidth(int n) {
        if (!this.isValidColumn(n)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rows) {
            if (this.table[n3][n] != null) {
                n2 = Math.max(n2, this.table[n3][n].getPreferredSize().width);
            }
            ++n3;
        }
        if (n2 > 0) {
            n2 = Math.max(n2, this.minColWidth[n]);
        }
        return n2;
    }

    public int maximumRowHeight(int n) {
        if (!this.isValidRow(n)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.cols) {
            if (this.table[n][n3] != null) {
                n2 = Math.max(n2, this.table[n][n3].getMaximumSize().height);
            }
            ++n3;
        }
        if (n2 > 0) {
            n2 = Math.max(n2, this.minRowHeight[n]);
        }
        return n2;
    }

    public int maximumColumnWidth(int n) {
        if (!this.isValidColumn(n)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rows) {
            if (this.table[n3][n] != null) {
                n2 = Math.max(n2, this.table[n3][n].getMaximumSize().width);
            }
            ++n3;
        }
        if (n2 > 0) {
            n2 = Math.max(n2, this.minColWidth[n]);
        }
        return n2;
    }

    public int[] minimumRowHeights() {
        int[] nArray = new int[this.rows];
        int n = 0;
        while (n < this.rows) {
            nArray[n] = this.minimumRowHeight(n);
            ++n;
        }
        return nArray;
    }

    public int[] minimumColumnWidths() {
        int[] nArray = new int[this.cols];
        int n = 0;
        while (n < this.cols) {
            nArray[n] = this.minimumColumnWidth(n);
            ++n;
        }
        return nArray;
    }

    public int[] preferredRowHeights() {
        int[] nArray = new int[this.rows];
        int n = 0;
        while (n < this.rows) {
            nArray[n] = this.preferredRowHeight(n);
            ++n;
        }
        return nArray;
    }

    public int[] preferredColumnWidths() {
        int[] nArray = new int[this.cols];
        int n = 0;
        while (n < this.cols) {
            nArray[n] = this.preferredColumnWidth(n);
            ++n;
        }
        return nArray;
    }

    public int[] maximumRowHeights() {
        int[] nArray = new int[this.rows];
        int n = 0;
        while (n < this.rows) {
            nArray[n] = this.maximumRowHeight(n);
            ++n;
        }
        return nArray;
    }

    public int[] maximumColumnWidths() {
        int[] nArray = new int[this.cols];
        int n = 0;
        while (n < this.cols) {
            nArray[n] = this.maximumColumnWidth(n);
            ++n;
        }
        return nArray;
    }

    protected void layoutContainer(int[] nArray, int[] nArray2, Insets insets) {
        if (nArray == null || nArray2 == null) {
            return;
        }
        int n = Math.min(this.cols, nArray.length);
        int n2 = Math.min(this.rows, nArray2.length);
        Dimension dimension = null;
        Point point = null;
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = 0;
        int n6 = 0;
        Component component = null;
        int n7 = 0;
        while (n7 < n2) {
            if (nArray2[n7] > 0) {
                n3 = insets.left;
                int n8 = 0;
                while (n8 < n) {
                    if (nArray[n8] > 0) {
                        component = this.table[n7][n8];
                        if (component != null) {
                            dimension = new Dimension(component.getPreferredSize());
                            n5 = dimension.width;
                            n6 = dimension.height;
                            point = this.applyAlignment(n3, n4, nArray[n8], nArray2[n7], n5, n6, this.getEffectiveCellAlignment(n7, n8));
                            component.setBounds(point.x, point.y, n5, n6);
                        }
                        n3 += this.hgap + nArray[n8];
                    }
                    ++n8;
                }
                n4 += this.vgap + nArray2[n7];
            }
            ++n7;
        }
    }

    protected CellPosition getNextAvailablePosition() {
        int n;
        int n2;
        if (this.orientation == 1) {
            n2 = 0;
            while (n2 < this.rows) {
                n = 0;
                while (n < this.cols) {
                    if (this.table[n2][n] == null) {
                        return new CellPosition(n2, n);
                    }
                    ++n;
                }
                ++n2;
            }
        }
        if (this.orientation == 0) {
            n2 = 0;
            while (n2 < this.cols) {
                n = 0;
                while (n < this.rows) {
                    if (this.table[n][n2] == null) {
                        return new CellPosition(n, n2);
                    }
                    ++n;
                }
                ++n2;
            }
        }
        return null;
    }

    protected Point applyAlignment(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Point point = new Point();
        int n8 = n3 - n5;
        int n9 = n4 - n6;
        if (n8 < 0) {
            n8 = 0;
        }
        if (n9 < 0) {
            n9 = 0;
        }
        int n10 = n;
        int n11 = n + n8 / 2;
        int n12 = n + n8;
        int n13 = n2;
        int n14 = n2 + n9 / 2;
        int n15 = n2 + n9;
        switch (n7) {
            case 2: {
                point.setLocation(n12, n13);
                break;
            }
            case 3: {
                point.setLocation(n12, n14);
                break;
            }
            case 4: {
                point.setLocation(n12, n15);
                break;
            }
            case 1: {
                point.setLocation(n11, n13);
                break;
            }
            case 0: {
                point.setLocation(n11, n14);
                break;
            }
            case 5: {
                point.setLocation(n11, n15);
                break;
            }
            case 8: {
                point.setLocation(n10, n13);
                break;
            }
            case 7: {
                point.setLocation(n10, n14);
                break;
            }
            default: {
                point.setLocation(n10, n15);
            }
        }
        return point;
    }

    void setRows(int n) {
        int n2;
        if (n < 0) {
            n = 0;
        }
        int n3 = this.rows;
        int n4 = this.cols;
        this.rows = n;
        Component[][] componentArray = new Component[this.rows][n4];
        int[][] nArray = new int[this.rows][n4];
        int[] nArray2 = new int[this.rows];
        int[] nArray3 = new int[this.rows];
        int n5 = Math.min(this.rows, n3);
        int n6 = 0;
        while (n6 < n5) {
            n2 = 0;
            while (n2 < n4) {
                componentArray[n6][n2] = this.table[n6][n2];
                nArray[n6][n2] = this.cellAlignment[n6][n2];
                ++n2;
            }
            nArray2[n6] = this.rowAlignment[n6];
            nArray3[n6] = this.minRowHeight[n6];
            ++n6;
        }
        if (this.rows > n3) {
            n2 = n5;
            while (n2 < this.rows) {
                int n7 = 0;
                while (n7 < n4) {
                    nArray[n2][n7] = this.colAlignment[n7];
                    ++n7;
                }
                nArray2[n2] = 36;
                nArray3[n2] = -1;
                ++n2;
            }
        }
        this.table = componentArray;
        this.cellAlignment = nArray;
        this.rowAlignment = nArray2;
        this.minRowHeight = nArray3;
    }

    void setColumns(int n) {
        int n2;
        if (n < 0) {
            n = 0;
        }
        int n3 = this.rows;
        int n4 = this.cols;
        this.cols = n;
        Component[][] componentArray = new Component[n3][this.cols];
        int[][] nArray = new int[n3][this.cols];
        int[] nArray2 = new int[this.cols];
        int[] nArray3 = new int[this.cols];
        int n5 = Math.min(this.cols, n4);
        int n6 = 0;
        while (n6 < n5) {
            n2 = 0;
            while (n2 < n3) {
                componentArray[n2][n6] = this.table[n2][n6];
                nArray[n2][n6] = this.cellAlignment[n2][n6];
                ++n2;
            }
            nArray2[n6] = this.colAlignment[n6];
            nArray3[n6] = this.minColWidth[n6];
            ++n6;
        }
        if (this.cols > n4) {
            n2 = n4;
            while (n2 < this.cols) {
                int n7 = 0;
                while (n7 < n3) {
                    nArray[n7][n2] = this.rowAlignment[n7];
                    ++n7;
                }
                nArray2[n2] = 36;
                nArray3[n2] = -1;
                ++n2;
            }
        }
        this.table = componentArray;
        this.cellAlignment = nArray;
        this.colAlignment = nArray2;
        this.minColWidth = nArray3;
    }

    void setCellAlignmentImpl(int n, int n2, int n3) {
        if (!this.isValidRow(n) || !this.isValidColumn(n2)) {
            return;
        }
        if ((n3 = this.adjustAlignment(n3)) == 37) {
            return;
        }
        this.cellAlignment[n][n2] = n3;
    }

    int adjustAlignment(int n) {
        switch (n) {
            case -1: {
                n = 6;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 36: {
                break;
            }
            default: {
                n = 37;
            }
        }
        return n;
    }
}

