/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.Zoo;
import edu.neu.ccs.gui.ZooGroup;
import edu.neu.ccs.util.DimensionUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class Laminate
extends JComponent
implements ComponentListener {
    private Component target = null;
    private boolean activated = true;
    private boolean selected = false;
    private Point moveOffset = new Point();
    private MouseActionAdapter adapter = null;
    private boolean resizeable = true;
    private boolean moveable = true;
    private boolean resizingX = false;
    private boolean resizingY = false;

    public Laminate(Component component, boolean bl) {
        this.installMouseAdapter();
        this.setTarget(component);
        this.setActivated(bl);
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.setVisible(this.target.isVisible());
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.setLocation(this.target.getLocation());
        this.getZoo().repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setSize(this.target.getSize());
        this.getZoo().repaint();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.setVisible(this.target.isVisible());
    }

    public void setTarget(Component component) {
        if (this.target != null) {
            this.target.removeComponentListener(this);
            this.setActivated(false);
        }
        this.target = component;
        if (this.target != null) {
            this.target.addComponentListener(this);
            this.setActivated(true);
            this.setBounds(this.target.getBounds());
        }
    }

    public Component getTarget() {
        return this.target;
    }

    public void setActivated(boolean bl) {
        if (this.activated != bl) {
            this.activated = bl;
            if (this.activated) {
                this.adapter.addAsListenerTo(this);
            } else {
                this.adapter.removeAsListenerTo(this);
            }
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public MouseActionAdapter getMouseActionAdapter() {
        return this.adapter;
    }

    public void setLocation(int n, int n2) {
        this.setBoundsImpl(n, n2, this.getWidth(), this.getHeight());
    }

    public void setLocation(Point point) {
        this.setBoundsImpl(point.x, point.y, this.getWidth(), this.getHeight());
    }

    public void setSize(int n, int n2) {
        this.setBoundsImpl(this.getX(), this.getY(), n, n2);
    }

    public void setSize(Dimension dimension) {
        this.setBoundsImpl(this.getX(), this.getY(), dimension.width, dimension.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setBoundsImpl(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBoundsImpl(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setMoveable(boolean bl) {
        this.moveable = bl;
    }

    public boolean isMoveable() {
        return this.moveable && this.getZoo().allowsMove();
    }

    public void setResizeable(boolean bl) {
        this.resizeable = bl;
    }

    public boolean isResizeable() {
        return this.resizeable && this.getZoo().allowsResize();
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isSelected()) {
            if (this.getZoo().hasFocus()) {
                graphics.setColor(this.getZoo().getFocusedHighlightColor());
            } else {
                graphics.setColor(this.getZoo().getUnfocusedHighlightColor());
            }
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this.isResizableX()) {
                graphics.fillRect(n - 5, n2 / 2 - 2, 5, 5);
            }
            if (this.isResizableY()) {
                graphics.fillRect(n / 2 - 2, n2 - 5, 5, 5);
            }
            if (this.isResizableX() && this.isResizableY()) {
                graphics.fillRect(n - 5, n2 - 5, 5, 5);
            }
        }
    }

    protected Zoo getZoo() {
        return (Zoo)this.getParent();
    }

    protected void installMouseAdapter() {
        this.adapter = new MouseActionAdapter(this);
        this.installSelectionActions();
        this.installCursorActions();
        this.installManipulationActions();
    }

    protected void installSelectionActions() {
        this.adapter.addMousePressedAction(new MouseAction(){

            public void mouseActionPerformed(MouseEvent mouseEvent) {
                Zoo zoo = Laminate.this.getZoo();
                if (mouseEvent.isShiftDown()) {
                    if (Laminate.this.isSelected()) {
                        zoo.removeFromSelection(Laminate.this.getTarget());
                    } else {
                        zoo.addToSelection(Laminate.this.getTarget());
                    }
                } else if (!Laminate.this.isSelected() || Laminate.this.getZoo().getSelectedComponentCount() != 1) {
                    zoo.selectOnly(Laminate.this.getTarget());
                }
            }
        });
    }

    protected void installCursorActions() {
        MouseAction mouseAction = new MouseAction(){

            public void mouseActionPerformed(MouseEvent mouseEvent) {
                if (!Laminate.this.isSelected()) {
                    return;
                }
                int n = Laminate.this.getWidth();
                int n2 = Laminate.this.getHeight();
                int n3 = Laminate.this.getCursor().getType();
                if (Laminate.this.resizingX || Laminate.this.resizingY) {
                    return;
                }
                if (Laminate.this.inSE(mouseEvent.getX(), mouseEvent.getY(), 5) && Laminate.this.isResizableXY()) {
                    n3 = 5;
                } else if (Laminate.this.inS(mouseEvent.getX(), mouseEvent.getY(), 5) && Laminate.this.isResizableY()) {
                    n3 = 9;
                } else if (Laminate.this.inE(mouseEvent.getX(), mouseEvent.getY(), 5) && Laminate.this.isResizableX()) {
                    n3 = 11;
                } else if (Laminate.this.isMoveable()) {
                    n3 = 13;
                }
                if (Laminate.this.getCursor().getType() != n3) {
                    Laminate.this.setCursor(new Cursor(n3));
                }
            }
        };
        this.adapter.addMouseMovedAction(mouseAction);
        this.adapter.addMouseEnteredAction(mouseAction);
        this.adapter.addMouseExitedAction(new MouseAction(){

            public void mouseActionPerformed(MouseEvent mouseEvent) {
                if (!Laminate.this.resizingX && !Laminate.this.resizingY) {
                    Laminate.this.setCursor(new Cursor(0));
                }
            }
        });
    }

    protected void installManipulationActions() {
        this.adapter.addMousePressedAction(new MouseAction(){

            public void mouseActionPerformed(MouseEvent mouseEvent) {
                if (!Laminate.this.isSelected()) {
                    return;
                }
                if (Laminate.this.inSE(mouseEvent.getX(), mouseEvent.getY(), 5) && Laminate.this.isResizableXY()) {
                    Laminate.this.setResizing(true, true);
                } else if (Laminate.this.inS(mouseEvent.getX(), mouseEvent.getY(), 5) && Laminate.this.isResizableY()) {
                    Laminate.this.setResizing(false, true);
                } else if (Laminate.this.inE(mouseEvent.getX(), mouseEvent.getY(), 5) && Laminate.this.isResizableX()) {
                    Laminate.this.setResizing(true, false);
                } else if (Laminate.this.isMoveable()) {
                    Laminate.this.startMoveAt(mouseEvent);
                }
            }
        });
        this.adapter.addMouseDraggedAction(new MouseAction(){

            public void mouseActionPerformed(MouseEvent mouseEvent) {
                if (!Laminate.this.isSelected()) {
                    return;
                }
                if (Laminate.this.resizingX || Laminate.this.resizingY) {
                    Laminate.this.resizeTo(mouseEvent);
                } else if (Laminate.this.isMoveable()) {
                    Laminate.this.moveTo(mouseEvent);
                }
            }
        });
        this.adapter.addMouseReleasedAction(new MouseAction(){

            public void mouseActionPerformed(MouseEvent mouseEvent) {
                if (Laminate.this.resizingX || Laminate.this.resizingY) {
                    Laminate.this.setResizing(false, false);
                    if (Laminate.this.getTarget() instanceof ZooGroup) {
                        ZooGroup zooGroup = (ZooGroup)Laminate.this.getTarget();
                        zooGroup.endResize();
                    }
                    if (Laminate.this.getTarget().contains(mouseEvent.getPoint())) {
                        Laminate.this.setCursor(new Cursor(13));
                    } else {
                        Laminate.this.setCursor(new Cursor(0));
                    }
                }
            }
        });
    }

    protected void startMoveAt(MouseEvent mouseEvent) {
        this.moveOffset.setLocation(mouseEvent.getX(), mouseEvent.getY());
        this.setResizing(false, false);
    }

    protected Rectangle restrictBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = new Dimension(n3, n4);
        if (this.getZoo() != null && this.getZoo().isRestrictingBounds()) {
            Rectangle rectangle = this.getZooInnerBounds();
            n = Math.min(Math.max(rectangle.x, n), rectangle.x + rectangle.width - this.target.getWidth());
            n2 = Math.min(Math.max(rectangle.y, n2), rectangle.y + rectangle.height - this.target.getHeight());
            dimension = DimensionUtilities.max(dimension, this.target.getMinimumSize());
            dimension = DimensionUtilities.min(dimension, this.target.getMaximumSize());
            dimension.width = Math.max(0, Math.min(dimension.width, rectangle.x + rectangle.width - this.target.getX()));
            dimension.height = Math.max(0, Math.min(dimension.height, rectangle.y + rectangle.height - this.target.getY()));
        }
        return new Rectangle(n, n2, dimension.width, dimension.height);
    }

    protected void moveTo(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        n = this.getX() + n - this.moveOffset.x;
        n2 = this.getY() + n2 - this.moveOffset.y;
        this.target.setBounds(this.restrictBounds(n, n2, this.target.getWidth(), this.target.getHeight()));
    }

    protected void resizeTo(MouseEvent mouseEvent) {
        Dimension dimension = new Dimension(mouseEvent.getX(), mouseEvent.getY());
        if (!this.resizingX) {
            dimension.width = this.getWidth();
        }
        if (!this.resizingY) {
            dimension.height = this.getHeight();
        }
        this.target.setBounds(this.restrictBounds(this.target.getX(), this.target.getY(), dimension.width, dimension.height));
        this.revalidateTarget();
    }

    protected void setResizing(boolean bl, boolean bl2) {
        this.resizingX = bl;
        this.resizingY = bl2;
        if ((this.resizingX || this.resizingY) && this.getTarget() instanceof ZooGroup) {
            ZooGroup zooGroup = (ZooGroup)this.getTarget();
            zooGroup.startResize();
        }
    }

    protected boolean isResizableX() {
        return this.isResizeable() && this.target.getMinimumSize().width < this.target.getMaximumSize().width;
    }

    protected boolean isResizableY() {
        return this.isResizeable() && this.target.getMinimumSize().height < this.target.getMaximumSize().height;
    }

    protected boolean isResizableXY() {
        return this.isResizableX() && this.isResizableY();
    }

    protected boolean inSE(int n, int n2, int n3) {
        return Point2D.distance(n, n2, this.getWidth(), this.getHeight()) <= (double)n3;
    }

    protected boolean inS(int n, int n2, int n3) {
        return Point2D.distance(n, n2, this.getWidth() / 2, this.getHeight()) <= (double)n3;
    }

    protected boolean inE(int n, int n2, int n3) {
        return Point2D.distance(n, n2, this.getWidth(), this.getHeight() / 2) <= (double)n3;
    }

    private void setBoundsImpl(int n, int n2, int n3, int n4) {
        this.target.removeComponentListener(this);
        Rectangle rectangle = this.restrictBounds(n, n2, n3, n4);
        super.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.target.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.target.addComponentListener(this);
    }

    private void revalidateTarget() {
        if (this.target instanceof JComponent) {
            JComponent jComponent = (JComponent)this.target;
            jComponent.revalidate();
            return;
        }
        if (this.target instanceof Container) {
            Container container = (Container)this.target;
            container.validate();
            return;
        }
    }

    private Rectangle getZooInnerBounds() {
        Dimension dimension = this.getZoo().getSize();
        Insets insets = this.getZoo().getInsets();
        return new Rectangle(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
    }
}

