/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XPoint2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.event.SwingPropertyChangeSupport;

public class Interval
implements Cloneable,
Serializable,
Stringable {
    protected static final String MINIMUM = "minimum";
    protected static final String MAXIMUM = "maximum";
    protected static final String MIDPOINT = "midpoint";
    protected static final String SIZE = "SIZE";
    protected double minimum = 0.0;
    protected double maximum = 0.0;
    protected double size = 0.0;
    protected double midpoint = 0.0;
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public Interval() {
    }

    public Interval(double d, double d2) {
        this.setEndpoints(d, d2);
    }

    public Interval(String string) throws ParseException {
        this.fromStringData(string);
    }

    public String toStringData() {
        return this.toString();
    }

    public void fromStringData(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("Input was null.", -1);
        }
        String[] stringArray = XPoint2D.decodeIntoPair(string);
        double d = XDouble.parseDouble(stringArray[0]);
        double d2 = XDouble.parseDouble(stringArray[1]);
        this.setEndpoints(d, d2);
    }

    public String toString() {
        return "[" + this.minimum + ";" + this.maximum + "]";
    }

    public void setEndpoints(double d, double d2) {
        double d3 = this.getMinimum();
        double d4 = this.getMaximum();
        double d5 = this.getMidpoint();
        double d6 = this.getSize();
        if (d <= d2) {
            this.minimum = d;
            this.maximum = d2;
        } else {
            this.minimum = d2;
            this.maximum = d;
        }
        this.size = this.maximum - this.minimum;
        this.midpoint = (this.minimum + this.maximum) / 2.0;
        if (this.getMinimum() != d3) {
            this.changeAdapter.firePropertyChange(MINIMUM, new Double(d3), new Double(this.getMinimum()));
        }
        if (this.getMaximum() != d4) {
            this.changeAdapter.firePropertyChange(MAXIMUM, new Double(d4), new Double(this.getMaximum()));
        }
        if (this.getMidpoint() != d5) {
            this.changeAdapter.firePropertyChange(MIDPOINT, new Double(d5), new Double(this.getMidpoint()));
        }
        if (this.getSize() != d6) {
            this.changeAdapter.firePropertyChange(SIZE, new Double(d6), new Double(this.getSize()));
        }
    }

    public void setInterval(Interval interval) {
        if (interval == null) {
            return;
        }
        this.setEndpoints(interval.minimum, interval.maximum);
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getSize() {
        return this.size;
    }

    public double getMidpoint() {
        return this.midpoint;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(string, propertyChangeListener);
    }
}

