/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.codec.CodecUtilities;
import edu.neu.ccs.gui.AlertEvent;
import edu.neu.ccs.gui.AlertListener;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.Fragile;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.util.DimensionUtilities;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DisplayPanel
extends JPanel
implements Displayable,
MalformedDataListener,
JPTConstants {
    public static final String CODEC = "codec";
    protected Color background = SystemColor.control;
    protected String codec = CodecUtilities.getDefaultCodec();

    public DisplayPanel() {
    }

    public DisplayPanel(boolean bl) {
        super(bl);
    }

    public DisplayPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public DisplayPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public void setViewState(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = CodecUtilities.decode(string);
        if (stringArray == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n < this.getComponentCount()) {
            Component component = this.getComponent(n);
            if (component instanceof Displayable) {
                Displayable displayable = (Displayable)((Object)component);
                if (stringArray != null && n2 < stringArray.length) {
                    displayable.setViewState(stringArray[n2++]);
                }
            }
            ++n;
        }
        this.firePropertyChange("view.state", null, string);
    }

    public String getViewState() {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.getComponentCount()) {
            stringArray = this.getComponent(n);
            if (stringArray instanceof Displayable) {
                Displayable displayable = (Displayable)stringArray;
                vector.add(displayable.getViewState());
            }
            ++n;
        }
        stringArray = null;
        if (vector.size() > 0) {
            stringArray = new String[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                stringArray[n2] = (String)vector.get(n2);
                ++n2;
            }
        }
        return CodecUtilities.encode(stringArray, this.codec);
    }

    public void setDefaultViewState(String string) {
        String[] stringArray = CodecUtilities.decode(string);
        int n = 0;
        int n2 = 0;
        while (n < this.getComponentCount()) {
            Component component = this.getComponent(n);
            if (component instanceof Displayable) {
                Displayable displayable = (Displayable)((Object)component);
                if (stringArray != null && n2 < stringArray.length) {
                    displayable.setDefaultViewState(stringArray[n2++]);
                }
            }
            ++n;
        }
        this.firePropertyChange("default.view.state", null, string);
    }

    public String getDefaultViewState() {
        Object[] objectArray;
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        boolean bl = false;
        while (n < this.getComponentCount()) {
            objectArray = this.getComponent(n);
            if (objectArray instanceof Displayable) {
                Displayable displayable = (Displayable)objectArray;
                vector.add(displayable.getDefaultViewState());
            }
            ++n;
        }
        if (vector.size() > 0) {
            objectArray = vector.toArray();
            stringArray = new String[objectArray.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                stringArray[n2] = (String)objectArray[n2];
                ++n2;
            }
        }
        return CodecUtilities.encode(stringArray);
    }

    public void setEnabled(boolean bl) {
        int n = 0;
        while (n < this.getComponentCount()) {
            this.getComponent(n).setEnabled(bl);
            ++n;
        }
        super.setEnabled(bl);
    }

    public void reset() {
        int n = 0;
        while (n < this.getComponentCount()) {
            Component component = this.getComponent(n);
            if (component instanceof Displayable) {
                Displayable displayable = (Displayable)((Object)component);
                displayable.reset();
            }
            ++n;
        }
    }

    public void dataMalformed(MalformedDataEvent malformedDataEvent) {
        if (malformedDataEvent.isAlertOn()) {
            this.startAlert(malformedDataEvent);
        } else {
            this.endAlert(malformedDataEvent);
        }
    }

    public void startAlert(AlertEvent alertEvent) {
        this.background = this.getBackground();
        this.setBackground(SystemColor.textHighlight);
        int n = 0;
        while (n < this.getComponentCount()) {
            Component component = this.getComponent(n);
            if (component instanceof AlertListener) {
                AlertListener alertListener = (AlertListener)((Object)component);
                alertListener.startAlert(alertEvent);
            }
            ++n;
        }
    }

    public void endAlert(AlertEvent alertEvent) {
        this.setBackground(this.background);
        int n = 0;
        while (n < this.getComponentCount()) {
            Component component = this.getComponent(n);
            if (component instanceof AlertListener) {
                AlertListener alertListener = (AlertListener)((Object)component);
                alertListener.endAlert(alertEvent);
            }
            ++n;
        }
    }

    public Component add(Component component) {
        return this.add(component, -1);
    }

    public Component add(Component component, int n) {
        super.add(component, n);
        if (component != null && component instanceof Fragile) {
            Fragile fragile = (Fragile)((Object)component);
            fragile.addMalformedDataListener(this);
        }
        this.revalidate();
        return component;
    }

    public void add(Component component, Object object) {
        super.add(component, object);
        if (component != null && component instanceof Fragile) {
            Fragile fragile = (Fragile)((Object)component);
            fragile.addMalformedDataListener(this);
        }
        this.revalidate();
    }

    public void add(Component component, Object object, int n) {
        super.add(component, object, n);
        if (component != null && component instanceof Fragile) {
            Fragile fragile = (Fragile)((Object)component);
            fragile.addMalformedDataListener(this);
        }
        this.revalidate();
    }

    public Component add(String string, Component component) {
        super.add(string, component);
        if (component != null && component instanceof Fragile) {
            Fragile fragile = (Fragile)((Object)component);
            fragile.addMalformedDataListener(this);
        }
        this.revalidate();
        return component;
    }

    public Component addObject(Object object) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component);
        }
        return component;
    }

    public Component addObject(Object object, int n) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, n);
        }
        return component;
    }

    public Component addObject(Object object, Object object2) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, object2);
        }
        return component;
    }

    public Component addObject(Object object, Object object2, int n) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, object2, n);
        }
        return component;
    }

    public Component makeComponent(Object object) {
        return ComponentFactory.makeComponent(object);
    }

    public void remove(Component component) {
        super.remove(component);
        if (component != null && component instanceof Fragile) {
            Fragile fragile = (Fragile)((Object)component);
            fragile.removeMalformedDataListener(this);
        }
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(int n) {
        try {
            block4: {
                try {
                    Component component = this.getComponent(n);
                    if (component == null || !(component instanceof Fragile)) break block4;
                    Fragile fragile = (Fragile)((Object)component);
                    fragile.removeMalformedDataListener(this);
                }
                catch (Exception exception) {
                    Object var5_6 = null;
                    super.remove(n);
                    this.revalidate();
                    return;
                }
            }
            Object var5_5 = null;
            super.remove(n);
            this.revalidate();
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            super.remove(n);
            this.revalidate();
            throw throwable;
        }
    }

    public void removeAll() {
        while (this.getComponentCount() > 0) {
            this.remove(0);
        }
    }

    public void uniformizeSize() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        JComponent jComponent = null;
        Dimension dimension = new Dimension();
        int n2 = 0;
        while (n2 < n) {
            if (componentArray[n2] instanceof JComponent) {
                jComponent = (JComponent)componentArray[n2];
                dimension = DimensionUtilities.max(dimension, jComponent.getPreferredSize());
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            if (componentArray[n3] instanceof JComponent) {
                jComponent = (JComponent)componentArray[n3];
                jComponent.setPreferredSize(dimension);
            }
            ++n3;
        }
    }

    public void setCodec(String string) {
        String string2 = this.getCodec();
        if (string != null) {
            this.codec = string;
        }
        if (this.getCodec() != string2) {
            this.firePropertyChange(CODEC, string2, this.getCodec());
        }
    }

    public String getCodec() {
        return this.codec;
    }
}

