/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AlignedLayout;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.util.DimensionUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class ComponentWrapper
extends DisplayPanel {
    protected WrappedComponent wrapper = null;

    public ComponentWrapper(Component component) {
        this(component, 0);
    }

    public ComponentWrapper(Component component, int n) {
        super(new AlignedLayout(n));
        this.setWrappedComponent(component);
        this.setMinimumSize(DimensionUtilities.createMinimumDimension());
        this.setMaximumSize(DimensionUtilities.createMaximumDimension());
    }

    public void setEnabled(boolean bl) {
        this.getWrappedComponent().setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setWrappedComponent(Component component) {
        if (component == null) {
            throw new NullPointerException("The component to be wrapped is null.");
        }
        if (this.wrapper != null) {
            this.remove(this.wrapper);
        }
        this.wrapper = new WrappedComponent(component);
        this.add(this.wrapper);
    }

    public Component getWrappedComponent() {
        return this.wrapper.getWrappedComponent();
    }

    public void setAbsoluteSize(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        dimension = DimensionUtilities.createDimension(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public void setAbsoluteSize(int n, int n2) {
        this.setAbsoluteSize(DimensionUtilities.createDimension(n, n2));
    }

    public void setMinimumSize(Dimension dimension) {
        if (dimension == null) {
            dimension = DimensionUtilities.createMinimumDimension();
        }
        this.wrapper.setMinimumSize(dimension);
        this.revalidate();
    }

    public void setMinimumSize(int n, int n2) {
        this.setMinimumSize(DimensionUtilities.createDimension(n, n2));
    }

    public Dimension getMinimumSize() {
        return this.wrapper.getMinimumSize();
    }

    public void setMaximumSize(Dimension dimension) {
        if (dimension == null) {
            dimension = DimensionUtilities.createMaximumDimension();
        }
        this.wrapper.setMaximumSize(dimension);
        this.revalidate();
    }

    public void setMaximumSize(int n, int n2) {
        this.setMaximumSize(DimensionUtilities.createDimension(n, n2));
    }

    public Dimension getMaximumSize() {
        return this.wrapper.getMaximumSize();
    }

    public void setPreferredSize(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        this.wrapper.setPreferredSize(dimension);
        this.revalidate();
    }

    public void setPreferredSize(int n, int n2) {
        this.setPreferredSize(DimensionUtilities.createDimension(n, n2));
    }

    public Dimension getPreferredSize() {
        return this.wrapper.getPreferredSize();
    }

    public void setAlignment(int n) {
        LayoutManager layoutManager = this.getLayout();
        if (!(layoutManager instanceof AlignedLayout)) {
            return;
        }
        AlignedLayout alignedLayout = (AlignedLayout)layoutManager;
        alignedLayout.setAlignment(n);
    }

    public int getAlignment() {
        LayoutManager layoutManager = this.getLayout();
        if (!(layoutManager instanceof AlignedLayout)) {
            return -1;
        }
        AlignedLayout alignedLayout = (AlignedLayout)layoutManager;
        return alignedLayout.getAlignment();
    }

    class WrappedComponent
    extends JPanel {
        protected Dimension minimumSize = DimensionUtilities.createMinimumDimension();
        protected Dimension maximumSize = DimensionUtilities.createMaximumDimension();
        protected JScrollPane scroll = null;
        protected Border scrollBorder = null;
        protected Component inner = null;
        protected ComponentListener sizeListener = new ComponentAdapter(this){
            private final /* synthetic */ WrappedComponent this$1;
            {
                this.this$1 = wrappedComponent;
            }

            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = this.this$1.scroll.getSize();
                Dimension dimension2 = this.this$1.inner.getPreferredSize();
                if (dimension2.width > dimension.width || dimension2.height > dimension.height) {
                    this.this$1.scroll.setBorder(this.this$1.scrollBorder);
                } else {
                    this.this$1.scroll.setBorder(null);
                }
            }
        };

        public WrappedComponent(Component component) {
            this.inner = component;
            this.scroll = new JScrollPane(this.inner);
            this.scrollBorder = this.scroll.getBorder();
            this.scroll.setBorder(null);
            this.scroll.addComponentListener(this.sizeListener);
            this.setLayout(new BorderLayout());
            this.add((Component)this.scroll, "Center");
        }

        public Component getWrappedComponent() {
            return this.inner;
        }

        public void setMinimumSize(Dimension dimension) {
            this.minimumSize = DimensionUtilities.createDimension(dimension);
            this.maximumSize = DimensionUtilities.max(this.minimumSize, this.maximumSize);
        }

        public Dimension getMinimumSize() {
            return this.minimumSize;
        }

        public void setMaximumSize(Dimension dimension) {
            this.maximumSize = DimensionUtilities.createDimension(dimension);
            int n = this.scroll.getVerticalScrollBar().isVisible() ? this.scroll.getVerticalScrollBar().getWidth() : 0;
            int n2 = this.scroll.getHorizontalScrollBar().isVisible() ? this.scroll.getHorizontalScrollBar().getHeight() : 0;
            this.maximumSize = DimensionUtilities.expand(this.maximumSize, new Insets(0, 0, n2, n));
            this.minimumSize = DimensionUtilities.min(this.minimumSize, this.maximumSize);
        }

        public Dimension getMaximumSize() {
            return this.maximumSize;
        }

        public void setPreferredSize(Dimension dimension) {
            if (!(this.inner instanceof JComponent)) {
                return;
            }
            ((JComponent)this.inner).setPreferredSize(dimension);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = DimensionUtilities.createDimension(this.scroll.getPreferredSize());
            dimension = DimensionUtilities.min(dimension, this.maximumSize);
            dimension = DimensionUtilities.max(dimension, this.minimumSize);
            return dimension;
        }
    }
}

