/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.codec.CodecUtilities;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.RangeFilter;
import edu.neu.ccs.gui.ActionsPanel;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.Display;
import edu.neu.ccs.gui.DisplayCollection;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.ScrollableDisplay;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.util.JPTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public abstract class ArrayPanel
extends DisplayPanel
implements TypedView {
    public static final String CONTROLS = "controls";
    public static final String INCREMENT_BUTTON_TEXT = "increment.button.text";
    public static final String DECREMENT_BUTTON_TEXT = "decrement.button.text";
    public static final String LENGTH_PROMPT = "length.prompt";
    public static final String SET_BUTTON_TEXT = "set.button.text";
    public static final String LENGTH = "length";
    public static final String MINIMUM_LENGTH = "minimum.length";
    public static final String MAXIMUM_LENGTH = "maximum.length";
    public static final int NO_CONTROLS = 0;
    public static final int INCREMENT_DECREMENT = 1;
    public static final int LENGTH_TEXT_FIELD = 2;
    protected static final int CONTROLS_MASK = 3;
    public static final int DEFAULT_CONTROLS = 3;
    public static final int DEFAULT_ALIGNMENT = 3;
    public static final int DEFAULT_ORIENTATION = 1;
    public static final int DEFAULT_MINIMUM_LENGTH = 0;
    public static final int DEFAULT_MAXIMUM_LENGTH = Integer.MAX_VALUE;
    protected int align = 3;
    protected int controlsValue = 3;
    protected int minLength = 0;
    protected int maxLength = Integer.MAX_VALUE;
    protected int userMinLength = 0;
    protected int userMaxLength = 0;
    protected DisplayCollection views = null;
    protected ScrollableDisplay scroller = null;
    protected DisplayPanel controlPanel = null;
    protected Action increment = null;
    protected Action decrement = null;
    protected ActionsPanel lengthActions = new ActionsPanel();
    protected TextFieldView lengthField = new TextFieldView("");
    protected RangeFilter.Long lengthFilter = null;
    protected Action set = null;
    protected ActionsPanel setActions = new ActionsPanel();
    protected Display lengthControls = null;
    protected InputProperties properties = new InputProperties();
    protected String defaultViewState = null;

    public ArrayPanel() {
        this(null, 1, 3, 3);
    }

    public ArrayPanel(Stringable[] stringableArray) {
        this(stringableArray, 1, 3, 3);
    }

    public ArrayPanel(Stringable[] stringableArray, int n) {
        this(stringableArray, n, 3, 3);
    }

    public ArrayPanel(Stringable[] stringableArray, int n, int n2, int n3) {
        this.setLayout(new BorderLayout());
        this.views = new DisplayCollection();
        this.scroller = new ScrollableDisplay(this.views);
        this.add((Component)this.scroller, "Center");
        this.userMinLength = this.transformRawLengthToUserLength(this.minLength);
        this.userMaxLength = this.transformRawLengthToUserLength(this.maxLength);
        this.lengthFilter = new RangeFilter.Long(this.userMinLength, this.userMaxLength){

            public Stringable filterStringable(Stringable stringable) throws FilterException {
                try {
                    return super.filterStringable(stringable);
                }
                catch (FilterException filterException) {
                    throw new FilterException(stringable, ArrayPanel.this.createLengthSetOutOfBoundsMessage(filterException));
                }
            }
        };
        this.lengthField.setPreferredWidth(40);
        this.lengthControls = new Display(this.lengthField, "Length:", null);
        this.setOrientation(n);
        this.setControls(n2);
        this.setAlignment(n3);
        this.increment = new SimpleAction("Increment"){

            public void perform() {
                ArrayPanel.this.setLength(ArrayPanel.this.getLength() + 1);
            }
        };
        this.decrement = new SimpleAction("Decrement"){

            public void perform() {
                ArrayPanel.this.setLength(ArrayPanel.this.getLength() - 1);
            }
        };
        this.lengthActions.addAction(this.increment);
        this.lengthActions.addAction(this.decrement);
        this.set = new SimpleAction("Set"){

            public void perform() {
                ArrayPanel.this.applyLengthFromControls();
            }
        };
        this.setActions.addAction(this.set);
        this.lengthField.addActionListener(this.set);
        if (stringableArray != null) {
            int n4 = 0;
            while (n4 < stringableArray.length) {
                this.increment(stringableArray[n4].toStringData());
                ++n4;
            }
            this.setLength(stringableArray.length);
        } else {
            this.setLength(0);
        }
    }

    public abstract Stringable demandObject();

    public abstract Stringable requestObject() throws CancelledException;

    public void setInputProperties(InputProperties inputProperties) {
        InputProperties inputProperties2 = this.properties;
        this.properties = inputProperties;
        if (this.getInputProperties() != null && !this.getInputProperties().equals(inputProperties2)) {
            this.firePropertyChange("input.properties", inputProperties2, this.properties);
        }
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public abstract Class getDataType();

    public void setViewState(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = CodecUtilities.decode(string);
        if (stringArray == null) {
            return;
        }
        this.setLength(stringArray.length);
        this.views.setViewState(string);
        this.firePropertyChange("view.state", null, string);
    }

    public String getViewState() {
        return this.views.getViewState();
    }

    public void setDefaultViewState(String string) {
        this.defaultViewState = string;
        this.firePropertyChange("default.view.state", null, string);
    }

    public String getDefaultViewState() {
        if (this.defaultViewState == null) {
            return this.views.getDefaultViewState();
        }
        return this.defaultViewState;
    }

    public void reset() {
        this.setViewState(this.getDefaultViewState());
    }

    public Stringable[] demandObjectArray() {
        if (this.getLength() == 0) {
            return null;
        }
        Stringable[] stringableArray = new Stringable[this.getLength()];
        int n = 0;
        while (n < this.getLength()) {
            Display display = (Display)this.views.getItem(n);
            TypedView typedView = (TypedView)display.getDisplay();
            stringableArray[n] = typedView.demandObject();
            ++n;
        }
        return stringableArray;
    }

    public Stringable[] requestObjectArray() throws CancelledException {
        if (this.getLength() == 0) {
            return null;
        }
        Stringable[] stringableArray = new Stringable[this.getLength()];
        int n = 0;
        while (n < this.getLength()) {
            Display display = (Display)this.views.getItem(n);
            TypedView typedView = (TypedView)display.getDisplay();
            stringableArray[n] = typedView.requestObject();
            ++n;
        }
        return stringableArray;
    }

    public TypedView getView(int n) {
        Component component = this.views.getItem(n);
        Display display = (Display)component;
        return (TypedView)display.getDisplay();
    }

    public void setOrientation(int n) {
        int n2 = this.getOrientation();
        this.views.setOrientation(n);
        if (this.getOrientation() != n2) {
            this.firePropertyChange("orientation", n2, this.getOrientation());
        }
    }

    public int getOrientation() {
        return this.views.getOrientation();
    }

    public void setAlignment(int n) {
        int n2 = this.align;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.align = n;
                break;
            }
            case -1: {
                this.align = 3;
                break;
            }
            default: {
                return;
            }
        }
        this.revalidateDisplay();
        if (this.align != n2) {
            this.firePropertyChange("alignment", n2, this.getAlignment());
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setControls(int n) {
        int n2 = this.controlsValue;
        this.controlsValue = n == -1 ? 3 : n & 3;
        this.revalidateDisplay();
        if (this.controlsValue != n2) {
            this.firePropertyChange(CONTROLS, n2, this.getControls());
        }
    }

    public int getControls() {
        return this.controlsValue;
    }

    public void setIncrementButtonText(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getIncrementButtonText();
        this.increment.putValue("Name", string);
        if (this.getIncrementButtonText() != string2) {
            this.firePropertyChange(INCREMENT_BUTTON_TEXT, string2, this.getIncrementButtonText());
        }
    }

    public String getIncrementButtonText() {
        return (String)this.increment.getValue("Name");
    }

    public void setDecrementButtonText(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getDecrementButtonText();
        this.decrement.putValue("Name", string);
        if (this.getDecrementButtonText() != string2) {
            this.firePropertyChange(DECREMENT_BUTTON_TEXT, string2, this.getDecrementButtonText());
        }
    }

    public String getDecrementButtonText() {
        return (String)this.decrement.getValue("Name");
    }

    public void setLengthPrompt(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getLengthPrompt();
        this.lengthControls.setAnnotationText(string);
        if (this.getLengthPrompt() != string2) {
            this.firePropertyChange(LENGTH_PROMPT, string2, this.getLengthPrompt());
        }
    }

    public String getLengthPrompt() {
        return this.lengthControls.getAnnotationText();
    }

    public void setSetButtonText(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getSetButtonText();
        this.set.putValue("Name", string);
        if (this.getSetButtonText() != string2) {
            this.firePropertyChange(SET_BUTTON_TEXT, string2, this.getSetButtonText());
        }
    }

    public String getSetButtonText() {
        return (String)this.set.getValue("Name");
    }

    public void setLength(int n) {
        int n2 = this.getLength();
        if (n < this.minLength) {
            n = this.minLength;
        }
        if (n > this.maxLength) {
            n = this.maxLength;
        }
        int n3 = this.transformRawLengthToUserLength(n);
        this.lengthField.setViewState(n3 + "");
        while (this.getLength() < n) {
            this.increment(null);
        }
        while (this.getLength() > n) {
            this.decrement();
        }
        if (this.getLength() != n2) {
            this.firePropertyChange(LENGTH, n2, this.getLength());
        }
    }

    public int getLength() {
        return this.views.getItemCount();
    }

    public void setMinimumLength(int n) {
        int n2 = this.getMinimumLength();
        if (n < 0) {
            n = 0;
        }
        if (n > this.getMaximumLength()) {
            this.setMaximumLength(n);
        }
        this.minLength = n;
        this.userMinLength = this.transformRawLengthToUserLength(this.minLength);
        this.lengthFilter.setMinimum(this.userMinLength);
        if (this.getLength() > this.minLength) {
            this.decrement.setEnabled(this.isEnabled());
        } else {
            this.decrement.setEnabled(false);
            if (this.getLength() < this.minLength) {
                this.setLength(this.minLength);
            }
        }
        if (this.getMinimumLength() != n2) {
            this.firePropertyChange(MINIMUM_LENGTH, n2, this.getMinimumLength());
        }
    }

    public int getMinimumLength() {
        return this.minLength;
    }

    public void setMaximumLength(int n) {
        int n2 = this.getMaximumLength();
        if (n < 0) {
            n = 0;
        }
        if (n < this.getMinimumLength()) {
            this.setMinimumLength(n);
        }
        this.maxLength = n;
        this.userMaxLength = this.transformRawLengthToUserLength(this.maxLength);
        this.lengthFilter.setMaximum(this.userMaxLength);
        if (this.getLength() < this.maxLength) {
            this.increment.setEnabled(this.isEnabled());
        } else {
            this.increment.setEnabled(false);
            while (this.getLength() > this.maxLength) {
                this.setLength(this.maxLength);
            }
        }
        if (this.getMaximumLength() != n2) {
            this.firePropertyChange(MAXIMUM_LENGTH, n2, this.getMaximumLength());
        }
    }

    public int getMaximumLength() {
        return this.maxLength;
    }

    protected Display.Settings createDisplaySettingsFor(int n) {
        return new Display.Settings(this.createPromptTextFor(n), null, 2, -1);
    }

    protected TypedView createViewFor(int n) {
        return new TextFieldView("");
    }

    protected String createPromptTextFor(int n) {
        return n + ":";
    }

    public String createLengthSetOutOfBoundsMessage(FilterException filterException) {
        try {
            if (filterException.getModel() instanceof XNumber) {
                XNumber xNumber = (XNumber)filterException.getModel();
                int n = this.transformUserLengthToRawLength(xNumber.intValue());
                if (n < this.minLength) {
                    return "The given " + this.getLengthPrompt() + " is less than the minimum " + this.getLengthPrompt() + " of " + this.transformRawLengthToUserLength(this.minLength);
                }
                return "The given " + this.getLengthPrompt() + " is greater than the maximum " + this.getLengthPrompt() + " of " + this.transformRawLengthToUserLength(this.maxLength);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return "The provided " + this.getLengthPrompt() + " is not in the range [" + this.transformRawLengthToUserLength(this.minLength) + ", " + this.transformRawLengthToUserLength(this.maxLength) + "]";
    }

    protected void increment(String string) {
        Display display = this.createDisplayFor(this.getLength());
        this.views.add(display);
        this.decrement.setEnabled(this.isEnabled());
        if (this.getLength() == this.maxLength) {
            this.increment.setEnabled(false);
        }
        if (string != null) {
            Displayable displayable = display;
            displayable.setViewState(string);
        }
    }

    protected TypedView decrement() {
        Component component = this.views.getItem(this.getLength() - 1);
        this.views.remove(component);
        Display display = (Display)component;
        TypedView typedView = (TypedView)display.getDisplay();
        this.increment.setEnabled(this.isEnabled());
        if (this.getLength() == this.minLength) {
            this.decrement.setEnabled(false);
        }
        return typedView;
    }

    protected void applyLengthFromControls() {
        int n;
        try {
            n = this.requestArrayLength();
        }
        catch (CancelledException cancelledException) {
            return;
        }
        this.setLength(n);
    }

    protected int requestArrayLength() throws CancelledException {
        return this.transformUserLengthToRawLength(this.lengthField.requestInt(this.lengthFilter));
    }

    protected int transformUserLengthToRawLength(int n) {
        return n;
    }

    protected int transformRawLengthToUserLength(int n) {
        return n;
    }

    protected void revalidateDisplay() {
        if (this.controlPanel != null) {
            this.remove(this.controlPanel);
        }
        this.controlPanel = this.createControlPanel();
        if (this.controlPanel != null) {
            this.add((Component)this.controlPanel, JPTUtilities.getBorderLayoutLocation(this.align));
        }
        this.revalidate();
    }

    protected DisplayPanel createControlPanel() {
        if (this.controlsValue == 0) {
            return null;
        }
        DisplayPanel displayPanel = new DisplayPanel();
        displayPanel.setLayout(new BoxLayout(displayPanel, 1));
        if ((this.controlsValue & 1) != 0) {
            displayPanel.add(this.lengthActions);
        }
        if ((this.controlsValue & 2) != 0) {
            JPanel jPanel = new JPanel(new FlowLayout(1));
            jPanel.add(this.lengthControls);
            jPanel.add(this.setActions);
            displayPanel.add(jPanel);
        }
        displayPanel.add(Box.createVerticalGlue());
        return displayPanel;
    }

    private final Display createDisplayFor(int n) {
        return new Display(this.createViewFor(n), this.createDisplaySettingsFor(n));
    }
}

