/* 
TestSuite.java  26 February 2003 */


import java.awt.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;

public class TestSuite extends JPFalt 
{
    public static void main(String[] args) { new TestSuite(); }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////
	 	
	/*----------------------------------------------------------------------- 
	 Test console channel for balloon input
	------------------------------------------------------------------------- */
    void TestConsoleChannel(){
    
        ChBalloonInput in = new ChConsoleReadBalloon();
        Balloon b = in.read();
        
        b.paintBalloon(window);
        println(b);
    }
    
	/*----------------------------------------------------------------------- 
	 Test GUI channel for balloon input
	------------------------------------------------------------------------- */
    void TestBalloonGUIin(){
    
        ChBalloonInput in = new ChGUIReadBalloon();
        Balloon b = in.read();
        
        b.paintBalloon(window);
        println(b);
		
	}
	
	/*----------------------------------------------------------------------- 
	 Test console channel and iterator for input of list of balloons
	------------------------------------------------------------------------- */
    void TestConsoleRange(){
    
        AListOfBalloons lob = new EmptyListOfBalloons();
        
        for (int x = 0; x < 3; x = x + 1){
        
            ChBalloonInput in = new ChConsoleReadBalloon();
            lob = new ConsListOfBalloons(in.read(), lob);
            
            ((ConsListOfBalloons)lob).first.paintBalloon(window);
            println(((ConsListOfBalloons)lob).first);
        }
    }
    
	
	/*----------------------------------------------------------------------- 
	 Test GUI channel and iterator for input of list of balloons
	------------------------------------------------------------------------- */
    void TestInGuiRange(){
    
        AListOfBalloons lob = new EmptyListOfBalloons();
        
        for (IRange it = new InGuiRange();
             it.hasMore();
             it.next()){
        
            lob = new ConsListOfBalloons((Balloon)it.current(), lob);
            
            ((ConsListOfBalloons)lob).first.paintBalloon(window);
            println(((ConsListOfBalloons)lob).first);
        }        
    }


	/*----------------------------------------------------------------------- 
	 Test console channel and iterator for input of list of balloons
	------------------------------------------------------------------------- */
    void TestInConsoleRange(){
    
        AListOfBalloons lob = new EmptyListOfBalloons();
        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            lob = new ConsListOfBalloons((Balloon)it.current(), lob);
            
            ((ConsListOfBalloons)lob).first.paintBalloon(window);
            println(((ConsListOfBalloons)lob).first);
        }
    }
    
 }

