/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern:
        iterator for console input of a list of balloons 
*/

import edu.neu.ccs.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.util.*;

import java.io.*;
import java.awt.*;

class InConsoleRange implements IRange, ConsoleAware {

    /*-------------------------------------------------------- 
     Member data
     *------------------------------------------------------*/
    /* a balloon object to hold values */
    protected Balloon b = new Balloon();
    
    /* determines whether the input has been closed */
    protected boolean closed = true;
    
    /* determines whether new baloon data has been submitted */
    protected boolean submitted = false;
    
    
       
    /*-------------------------------------------------------- 
     Constructor
     *------------------------------------------------------*/
    InConsoleRange() { 
    
        /* currently not closed */
        closed = false;   
        
        /* extract values for the first balloon */
        next();
    }
        
    /*--------------------------------------------------------
     Methods to implement the IRange interface
     *------------------------------------------------------*/

    public void next() {
        submitted = false;
        
        /* wait till user types in the input or ends input */
        read(); 
    }

    public Object current() {
        if ((submitted) && (!closed)){
            return b;
        }
        else{
            return null;
        }
    }
    
    public boolean hasMore() {
        return ((submitted) && (!closed)); 
    }
    
    /*--------------------------------------------------------------
     Methods and helpers to read and close the input
     *------------------------------------------------------------*/

    /* read data for one balloon from the console */
    public Balloon read(){
        
        try{
          b = new Balloon
            (requestInt("x: "),
             requestInt("y: "),
             requestInt("radius: "),
             new Color(requestShade("red shade: " ),
                       requestShade("green shade: "),
                       requestShade("blue shade: ")));
          submitted = true;
          return b;
        }
        catch(IOException e){
            console.out.println(e.getMessage());
        }
        return null;
    }
    
    /* requests a shade in valid range from console */
    protected int requestShade(String s) throws IOException{

            int shade = requestInt(s);
            if ((shade >= 0) && (shade <= 255))
                return shade;
        
            console.out.println("" + shade + " is not within 0-255 range");
            return requestShade(s);   
    }
    
    /* request one integer from the console */
    public int requestInt(String s) throws IOException{

        XInt temp = new XInt(0);
        boolean more = console.in.reading(s, (Stringable)temp);
        if (more)
            return temp.intValue();
        else
            closed = true;
            throw(new IOException("End of input."));
    }
    
}
        
